

#define BOOST_NUMERIC_BINDINGS_SUPERLU_PRINT

#include <iostream> 
#include <fstream>
#include <string>  
#include <boost/numeric/bindings/superlu/superlu.hpp>
#include <boost/numeric/bindings/traits/ublas_matrix.hpp>
#include <boost/numeric/bindings/traits/ublas_compressed.hpp>
 
namespace ublas = boost::numeric::ublas; 
namespace slu = boost::numeric::bindings::superlu; 


typedef ublas::compressed_matrix<double, ublas::column_major, 0,
  ublas::unbounded_array<int>, ublas::unbounded_array<double> > cm_t; 

typedef ublas::matrix<double, ublas::column_major> m_t; 


using namespace std; 

int main() {

  string f_name; 
  cout << "file -> ";
  cin >> f_name; 

  ifstream in_file (f_name.c_str()); 
//  ifstream in_file ("in1"); 
  int r, c, nz;
  double a;
  in_file >> r >> c;
  in_file >> nz; 

  cm_t dm (r, c, nz);
  m_t db (r, 1), dx (r, 1); 

  for (int i = 0; i < nz; ++i) {
    in_file >> r >> c;
    in_file >> a;
    dm (r, c) = a; 
  }
    
  in_file >> nz;
  
  for (int i = 0; i < nz; ++i) {
    in_file >> r;
    in_file >> a;
    db (r, 0) = a; 
  }

  int ord;
  in_file >> ord; 
  
  std::cout << "==> 1" << std::endl; 
  
  slu::gssv (dm, db,
	     static_cast<slu::permc_spec_t> (ord)
	     //, slu::attma
	     //, slu::atpla
	     //, slu::colamd
	     ); 
  std::cout << std::endl;

  std::cout << "==> 2" << std::endl; 
  
  for (int i = 0; i < db.size1(); ++i)
    std::cout << std::scientific << db (i, 0) << std::endl; 

  std::cout << std::endl << "==> 3" << std::endl; 
  
  dx = prod (dm, db); 
  
  for (int i = 0; i < db.size1(); ++i)
    std::cout << std::scientific << dx (i, 0) << std::endl; 

}
