
#define BOOST_NUMERIC_BINDINGS_SUPERLU_PRINT

#include <iostream> 
#include <complex> 
#include <boost/numeric/bindings/superlu/superlu.hpp>
#include <boost/numeric/bindings/traits/ublas_matrix.hpp>
#include <boost/numeric/bindings/traits/ublas_compressed.hpp>
 
namespace ublas = boost::numeric::ublas; 
namespace slu = boost::numeric::bindings::superlu; 

typedef ublas::compressed_matrix<double, ublas::column_major, 0,
  ublas::unbounded_array<int>, ublas::unbounded_array<double> > cm_t; 
typedef ublas::matrix<double, ublas::column_major> m_t; 

typedef std::complex<double> cmplx; 
typedef ublas::compressed_matrix<cmplx, ublas::column_major, 0,
  ublas::unbounded_array<int>, ublas::unbounded_array<cmplx> > cmplxcm_t; 
typedef ublas::matrix<cmplx, ublas::column_major> cmplxm_t; 

template <typename M>
void init_symm (M& m, char uplo = 'f') {
  size_t n
    = boost::numeric::bindings::traits::sparse_matrix_traits<M>::size1 (m);
  for (size_t i = 0; i < n; ++i) {
    m (i, i) = n;
    for (size_t j = i + 1; j < n; ++j) {
      if (uplo == 'u' || uplo == 'U')
        m (i, j) = n - (j - i);
      else if (uplo == 'l' || uplo == 'L')
        m (j, i) = n - (j - i);
      else
        m (i, j) = m (j, i) = n - (j - i);
    }
  }
}

int main() {

  cm_t mu (3, 3, 6);
  m_t b (3, 1), x (3, 1); 
  for (int i = 0; i < 3; ++i)
    x (i, 0) = 1.0; 

  init_symm (mu, 'u'); 
  b = prod (mu, x); 
  
  slu::gssv (mu, b, slu::unsymm_min_degree); 
  
  std::cout << std::endl;

  //////////////////////////////////////////////////////////

  std::cout << std::endl;
  std::cout << "========================================\n"; 
  std::cout << std::endl;

  cmplxcm_t cmu (3, 3, 6);
  cmplxm_t cb (3, 1), cx (3, 1); 
  init_symm (cmu, 'u'); 
  for (int i = 0; i < 3; ++i)
    cx (i, 0) = 1.0; 
  cb = prod (cmu, cx); 

  slu::gssv (cmu, cb, slu::unsymm_min_degree); 

  std::cout << std::endl;
  std::cout << "========================================\n"; 
  std::cout << std::endl;

  cmu (0, 0) = cmplx (25, 0);
  cmu (0, 1) = cmplx (-5, -5);
  cmu (0, 2) = cmplx (10, 5);

  cmu (1, 0) = cmplx (-5, 5);
  cmu (1, 1) = cmplx (51, 0);
  cmu (1, 2) = cmplx (4, -6);

  cmu (2, 0) = cmplx (10, -5);
  cmu (2, 1) = cmplx (4, 6);
  cmu (2, 2) = cmplx (71, 0);

  for (int i = 0; i < 3; ++i)
    cx (i, 0) = cmplx (1.0, -1.0); 

  cb = prod (cmu, cx); 

  slu::gssv (cmu, cb, slu::unsymm_min_degree); 

  std::cout << std::endl;

}
