// (-*- C++ -*- header)  

/*
 * 
 * Copyright (c) Kresimir Fresl 2003
 *
 * Permission to copy, modify, use and distribute this software 
 * for any non-commercial or commercial purpose is granted provided 
 * that this license appear on all copies of the software source code.
 *
 * Author assumes no responsibility whatsoever for its use and makes 
 * no guarantees about its quality, correctness or reliability.
 *
 * Author acknowledges the support of the Faculty of Civil Engineering, 
 * University of Zagreb, Croatia.
 *
 */

#ifndef BOOST_NUMERIC_BINDINGS_SUPERLU_OVERLOADS_H
#define BOOST_NUMERIC_BINDINGS_SUPERLU_OVERLOADS_H

#include <cassert> 
#include <complex>
#include <boost/numeric/bindings/superlu/superlu_decl.hpp> 


namespace boost { namespace numeric { namespace bindings {

  namespace superlu { namespace detail {

    void gssv (float, SuperMatrix* A, int* perm_c, int* perm_r, 
               SuperMatrix* L, SuperMatrix* U, SuperMatrix* B, int* info) 
    {
      sgssv (A, perm_c, perm_r, L, U, B, info); 
    }

    void gssv (double, SuperMatrix* A, int* perm_c, int* perm_r, 
               SuperMatrix* L, SuperMatrix* U, SuperMatrix* B, int* info) 
    {
      dgssv (A, perm_c, perm_r, L, U, B, info); 
    }

    void gssv (std::complex<float>, SuperMatrix* A, int* perm_c, int* perm_r, 
               SuperMatrix* L, SuperMatrix* U, SuperMatrix* B, int* info) 
    {
      cgssv (A, perm_c, perm_r, L, U, B, info); 
    }

    void gssv (std::complex<double>, SuperMatrix* A, int* perm_c, int* perm_r, 
               SuperMatrix* L, SuperMatrix* U, SuperMatrix* B, int* info) 
    {
      zgssv (A, perm_c, perm_r, L, U, B, info); 
    }


    ////////////////////////////////

    inline
    void Create_CompCol_Matrix (SuperMatrix* A, int m, int n, int nnz, 
                                float* nzval, int* rowind, int* colptr, 
                                Stype_t stype = SLU_NC, 
                                Dtype_t dtype = SLU_S, 
                                Mtype_t mtype = SLU_GE) 
    {
      assert (stype == SLU_NC); 
      assert (dtype == SLU_S); 
      assert (mtype == SLU_GE); 
      sCreate_CompCol_Matrix (A, m, n, nnz, nzval, rowind, colptr, 
                              SLU_NC, SLU_S, SLU_GE); 
    }

    inline 
    void Create_Dense_Matrix (SuperMatrix* A, int m, int n, 
                              float* vals, int ld_vals,
                              Stype_t stype = SLU_DN, 
                              Dtype_t dtype = SLU_S, 
                              Mtype_t mtype = SLU_GE) 
    {
      assert (stype == SLU_DN); 
      assert (dtype == SLU_S); 
      assert (mtype == SLU_GE); 
      sCreate_Dense_Matrix (A, m, n, vals, ld_vals, SLU_DN, SLU_S, SLU_GE); 
    }


    inline
    void Create_CompCol_Matrix (SuperMatrix* A, int m, int n, int nnz, 
                                double* nzval, int* rowind, int* colptr, 
                                Stype_t stype = SLU_NC, 
                                Dtype_t dtype = SLU_D, 
                                Mtype_t mtype = SLU_GE) 
    {
      assert (stype == SLU_NC); 
      assert (dtype == SLU_D); 
      assert (mtype == SLU_GE); 
      dCreate_CompCol_Matrix (A, m, n, nnz, nzval, rowind, colptr, 
                              SLU_NC, SLU_D, SLU_GE); 
    }

    inline 
    void Create_Dense_Matrix (SuperMatrix* A, int m, int n, 
                              double* vals, int ld_vals,
                              Stype_t stype = SLU_DN, 
                              Dtype_t dtype = SLU_D, 
                              Mtype_t mtype = SLU_GE) 
    {
      assert (stype == SLU_DN); 
      assert (dtype == SLU_D); 
      assert (mtype == SLU_GE); 
      dCreate_Dense_Matrix (A, m, n, vals, ld_vals, SLU_DN, SLU_D, SLU_GE); 
    }


    inline
    void Create_CompCol_Matrix (SuperMatrix* A, int m, int n, int nnz, 
                                std::complex<float>* nzval, 
                                int* rowind, int* colptr, 
                                Stype_t stype = SLU_NC, 
                                Dtype_t dtype = SLU_C, 
                                Mtype_t mtype = SLU_GE) 
    {
      assert (stype == SLU_NC); 
      assert (dtype == SLU_C); 
      assert (mtype == SLU_GE); 
      cCreate_CompCol_Matrix (A, m, n, nnz, 
                              reinterpret_cast<flt_complex*> (nzval), 
                              rowind, colptr, 
                              SLU_NC, SLU_C, SLU_GE); 
    }

    inline 
    void Create_Dense_Matrix (SuperMatrix* A, int m, int n, 
                              std::complex<float>* vals, int ld_vals,
                              Stype_t stype = SLU_DN, 
                              Dtype_t dtype = SLU_C, 
                              Mtype_t mtype = SLU_GE) 
    {
      assert (stype == SLU_DN); 
      assert (dtype == SLU_C); 
      assert (mtype == SLU_GE); 
      cCreate_Dense_Matrix (A, m, n, 
                            reinterpret_cast<flt_complex*> (vals), 
                            ld_vals, SLU_DN, SLU_C, SLU_GE); 
    }


    inline
    void Create_CompCol_Matrix (SuperMatrix* A, int m, int n, int nnz, 
                                std::complex<double>* nzval, 
                                int* rowind, int* colptr, 
                                Stype_t stype = SLU_NC, 
                                Dtype_t dtype = SLU_Z, 
                                Mtype_t mtype = SLU_GE) 
    {
      assert (stype == SLU_NC); 
      assert (dtype == SLU_Z); 
      assert (mtype == SLU_GE); 
      zCreate_CompCol_Matrix (A, m, n, nnz, 
                              reinterpret_cast<dbl_complex*> (nzval), 
                              rowind, colptr, 
                              SLU_NC, SLU_Z, SLU_GE); 
    }

    inline 
    void Create_Dense_Matrix (SuperMatrix* A, int m, int n, 
                              std::complex<double>* vals, int ld_vals,
                              Stype_t stype = SLU_DN, 
                              Dtype_t dtype = SLU_Z, 
                              Mtype_t mtype = SLU_GE) 
    {
      assert (stype == SLU_DN); 
      assert (dtype == SLU_Z); 
      assert (mtype == SLU_GE); 
      zCreate_Dense_Matrix (A, m, n, 
                            reinterpret_cast<dbl_complex*> (vals), 
                            ld_vals, SLU_DN, SLU_Z, SLU_GE); 
    }


    ////////////////////////////////

    void Print_CompCol_Matrix (float, char* what, SuperMatrix* A) {
      sPrint_CompCol_Matrix (what, A); 
    }
    void Print_Dense_Matrix (float, char* what, SuperMatrix* A) {
      sPrint_Dense_Matrix (what, A); 
    }
    void Print_SuperNode_Matrix (float, char* what, SuperMatrix* A) {
      sPrint_SuperNode_Matrix (what, A); 
    }

    void Print_CompCol_Matrix (double, char* what, SuperMatrix* A) {
      dPrint_CompCol_Matrix (what, A); 
    }
    void Print_Dense_Matrix (double, char* what, SuperMatrix* A) {
      dPrint_Dense_Matrix (what, A); 
    }
    void Print_SuperNode_Matrix (double, char* what, SuperMatrix* A) {
      dPrint_SuperNode_Matrix (what, A); 
    }

    void Print_CompCol_Matrix (std::complex<float>, 
                               char* what, SuperMatrix* A) 
    {
      cPrint_CompCol_Matrix (what, A); 
    }
    void Print_Dense_Matrix (std::complex<float>, 
                             char* what, SuperMatrix* A) 
    {
      cPrint_Dense_Matrix (what, A); 
    }
    void Print_SuperNode_Matrix (std::complex<float>, 
                                 char* what, SuperMatrix* A) 
    {
      cPrint_SuperNode_Matrix (what, A); 
    }

    void Print_CompCol_Matrix (std::complex<double>, 
                               char* what, SuperMatrix* A) 
    {
      zPrint_CompCol_Matrix (what, A); 
    }
    void Print_Dense_Matrix (std::complex<double>, 
                             char* what, SuperMatrix* A) 
    {
      zPrint_Dense_Matrix (what, A); 
    }
    void Print_SuperNode_Matrix (std::complex<double>, 
                                 char* what, SuperMatrix* A) 
    {
      zPrint_SuperNode_Matrix (what, A); 
    }

  }}

}}}


#endif 
