// Copyright David Abrahams 2005. Distributed under the Boost
// Software License, Version 1.0. (See accompanying
// file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <boost/sequence/algorithm/copy.hpp>
#include <boost/test/minimal.hpp>
#include <algorithm>

namespace sequence = boost::sequence;

int test_main( int argc, char* argv[] )
{
    boost::array<char,6> const hello = {{'h','e','l','l','o','\0'}};
    boost::array<char,11> buf = {{'0','1','2','3','4','5','6','7','8','9','\0'}};
    boost::array<char,11> buf2;

    sequence::algorithm::copy(hello, buf);
    
    sequence::algorithm::copy(
        sequence::algorithm::copy(hello, buf)
      , buf2
    );

    boost::array<char,11> const result = {{'h','e','l','l','o','\0','6','7','8','9','\0'}};
    BOOST_REQUIRE(
        std::equal(&buf[0],&buf[0]+buf.size(), &result[0] )
    );
    BOOST_REQUIRE(
        std::equal(&buf2[0],&buf2[0]+5,"6789")
    );
    
    return 0;
}

