// -*-C++-*- cool/property/identity_map.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   A property map where the key is identical to the value
// Version: $Id: identity_map.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_PROPERTY_IDENTITY_MAP_HPP)
#define COOL_PROPERTY_IDENTITY_MAP_HPP 1

#if !defined(COOL_TRAITS_PROPERTY_FWD_HPP)
#  include <cool/traits/property_fwd.hpp>
#endif

namespace cool
{
  // ------------------------------------------------------------------------

  struct identity_map {};

  template <typename Key>
  struct property_use_traits<identity_map, Key>
  {
    typedef Key value_type;
    typedef Key key_type;
  };

  // ------------------------------------------------------------------------

  template <typename Key>
  Key& get(identity_map&, Key& key)
  {
    return key;
  }

  template <typename Key>
  Key const& get(identity_map const&, Key const& key)
  {
    return key;
  }

  // ------------------------------------------------------------------------

  template <typename T, typename Key>
  void put(identity_map&, Key& key, T const& val)
  {
    key = val;
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_PROPERTY_IDENTITY_MAP_HPP */
