// -*-C++-*- cool/iterator/basic.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   Basic iterator usage utilities
// Version: $Id: basic.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ITERATOR_BASIC_HPP)
#define COOL_ITERATOR_BASIC_HPP 1

namespace cool
{
  // ------------------------------------------------------------------------

  template <typename Container>
  typename Container::iterator begin(Container& container)
  {
    return container.begin();
  }

  template <typename Container>
  typename Container::const_iterator begin(Container const& container)
  {
    return container.begin();
  }

  // ------------------------------------------------------------------------

  template <typename Container>
  typename Container::iterator end(Container& container)
  {
    return container.end();
  }

  template <typename Container>
  typename Container::const_iterator end(Container const& container)
  {
    return container.end();
  }

  // ------------------------------------------------------------------------
} // namespace cool

#endif /* COOL_ITERATOR_BASIC_HPP */
