// -*-C++-*- include/cool/functional/not.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   functor logically negating results of predicates
// Version: $Id: not.hpp,v 1.1.1.1 2003/01/07 00:15:07 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_FUNCTIONAL_NOT_HPP)
#define COOL_FUNCTIONAL_NOT_HPP 1

namespace cool
{

  // ------------------------------------------------------------------------

  template <typename UnaryFunction>
  struct not1_t
  {
    typedef bool                                  result_type;
    typedef typename UnaryFunction::argument_type argument_type;

    not1_t(UnaryFunction const& uf): m_pred(uf) {}
    bool operator()(typename UnaryFunction::argument_type const& a) const { return !m_pred(a); }
    bool operator()(typename UnaryFunction::argument_type const& a)       { return !m_pred(a); }
    UnaryFunction m_pred;
  };

  template <typename UnaryFunction>
  inline not1_t<UnaryFunction>
  not1(UnaryFunction const& uf)
  {
    return not1_t<UnaryFunction>(uf);
  }

  // ------------------------------------------------------------------------

  template <typename BinaryFunction>
  struct not2_t
  {
    typedef bool                                          result_type;
    typedef typename BinaryFunction::first_argument_type  first_argument_type;
    typedef typename BinaryFunction::second_argument_type second_argument_type;

    not2_t(BinaryFunction const& bf): m_pred(bf) {}
    bool operator()(typename BinaryFunction::first_argument_type const& a1,
		    typename BinaryFunction::second_argument_type const& a2) const { return !m_pred(a1, a2); }
    bool operator()(typename BinaryFunction::first_argument_type const& a1,
		    typename BinaryFunction::second_argument_type const& a2)       { return !m_pred(a1, a2); }
    BinaryFunction m_pred;
  };

  template <typename BinaryFunction>
  inline not2_t<BinaryFunction>
  not2(BinaryFunction const& bf)
  {
    return not2_t<BinaryFunction>(bf);
  }

  // ------------------------------------------------------------------------

#if 0
  template <typename Functor, int i> struct not_aux;
  template <typename Functor> struct not_aux<Functor, sizeof(char)> { typedef not1<Functor> type; };
  template <typename Functor> struct not_aux<Functor, sizeof(double)> { typedef not2<Functor> type; };

  namespace cool_aux
  {
    struct argument_type {};
    template <typename Functor> struct not_select: Functor { static argument_type* select() { return 0; } };
  }

  char not_select(void*);
  double not_select(cool_aux::argument_type*);

  template <typename Functor> struct not_aux2 { enum { value = sizeof(cool::not_select(cool_aux::not_select<Functor>::select())) }; };

  template <typename Functor>
  typename cool::not_aux<Functor, cool::not_aux2<Functor>::value>::type
  not_(Functor functor)
  {
    return typename cool::not_aux<Functor, cool::not_aux2<Functor>::value>::type(functor);
  }
#endif

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_FUNCTIONAL_NOT_HPP */
