// -*-C++-*- cool/functional/identity.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   The identity function
// Version: $Id: identity.hpp,v 1.1.1.1 2003/01/07 00:15:07 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_FUNCTIONAL_IDENTITY_HPP)
#define COOL_FUNCTIONAL_IDENTITY_HPP 1

namespace cool
{
  // ------------------------------------------------------------------------

  template <typename Val>
  struct identity
  {
    typedef Val result_type;
    typedef Val argument_type;

    Val const& operator()(Val const& val) const { return val; }
    Val&       operator()(Val& val) const       { return val; }
  };

  // ------------------------------------------------------------------------
} // namespace cool

#endif /* COOL_FUNCTIONAL_IDENTITY_HPP */
