// -*-C++-*- include/functional/constant.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   a functor returning a constant value
// Version: $Id: constant.hpp,v 1.1.1.1 2003/01/07 00:15:07 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_CONSTANT_HPP)
#define COOL_ALGORITHM_CONSTANT_HPP 1

namespace cool
{

  // ------------------------------------------------------------------------

  template <typename T>
  struct constant_t
  {
    typedef T result_type;
    constant_t(T const& val): m_value(val) {}
    T const& operator()() const { return m_value; }
  private:
    T m_value;
  };

  // ------------------------------------------------------------------------

  template <typename T>
  inline cool::constant_t<T>
  constant(T const& val)
  {
    return cool::constant_t<T>(val);
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_CONSTANT_HPP */
