// -*-C++-*- include/algorithm/transform_until.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   the transform_until() family of algorithms
// Version: $Id: transform_until.hpp,v 1.1.1.1 2003/01/07 00:15:07 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_TRANSFORM_UNTIL_HPP)
#define COOL_ALGORITHM_TRANSFORM_UNTIL_HPP 1

#if !defined(COOL_TRAITS_ITERATOR_HPP)
#  include "cool/traits/iterator.hpp"
#endif
#if !defined(COOL_TRAITS_PRIOERTY_HPP)
#  include "cool/traits/property.hpp"
#endif
#include <utility>

namespace cool
{

  // ------------------------------------------------------------------------
  // workhorse: transform_until()

  template <typename InputIterator, typename OutputIterator,
	    typename UnaryFunction, typename UnaryPredicate,
	    typename ReadPM, typename WritePM>
  std::pair<InputIterator, OutputIterator>
  transform_until(InputIterator begin1, InputIterator end1,
		  OutputIterator begin2,
		  UnaryFunction func, UnaryPredicate pred,
		  ReadPM read_pm, WritePM write_pm)
  {
    typedef typename cool::iterator_traits<InputIterator>::key_type          key_type;
    typedef typename cool::property_use_traits<ReadPM, key_type>::value_type value_type

    for (; begin1 != end1; ++begin1, ++begin2)
    {
      value_type const& tmp = get(read_pm, *begin1);
      if (pred(tmp))
	break;
      put(write_pm, *begin2, tmp);
    }

    return std::make_pair<InputIterator, OutputIterator>(begin1, begin2);
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_TRANSFORM_UNTIL_HPP */
