// -*-C++-*- include/cool/algorithm/search.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   search() family of algorithms
// Version: $Id: search.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_SEARCH_HPP)
#define COOL_ALGORITHM_SEARCH_HPP 1

#if !defined(COOL_ALGORITHM_FIND_HPP)
#  include "cool/algorithm/find.hpp"
#endif
#if !defined(COOL_ALGORITHM_MISMATCH_HPP)
#  include "cool/algorithm/mismatch.hpp"
#endif
#if !defined(COOL_ALGORITHM_NEXT_HPP)
#  include "cool/algorithm/next.hpp"
#endif
#if !defined(COOL_PROPERTY_IDENTITY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_BIND_HPP)
#  include "cool/functional/bind.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_EQUAL_TO_HPP)
#  include "cool/functional/equal_to.hpp"
#endif

namespace cool
{

  // ------------------------------------------------------------------------

  template <typename ForwardIterator1, typename ForwardIterator2,
	    typename BinaryPredicate, typename ReadPM1, typename ReadPM2>
  ForwardIterator1
  search(ForwardIterator1 begin1, ForwardIterator1 end1,
	 ForwardIterator2 begin2, ForwardIterator2 end2,
	 BinaryPredicate pred,
	 ReadPM1 pm1, ReadPM2 pm2)
  {
    if (begin2 == end2)
      return begin1;

    ForwardIterator2 aux = begin2;
    ++aux;

    for (; (begin1 = cool::find_if(begin1, end1, cool::bind2nd(pred, get(pm2, *begin2)), pm1)) != end1; ++begin1)
      if (cool::mismatch(cool::next(begin1), end1, aux, end2, pred, pm1, pm2).second == end2)
	break;
    return begin1;
  }

  // ------------------------------------------------------------------------

  template <typename ForwardIterator1, typename ForwardIterator2, typename BinaryPredicate>
  ForwardIterator1
  search(ForwardIterator1 begin1, ForwardIterator1 end1,
	 ForwardIterator2 begin2, ForwardIterator2 end2,
	 BinaryPredicate pred)
  {
    return cool::search(begin1, end1, begin2, end2, pred, cool::identity_map(), cool::identity_map());
  }

  // ------------------------------------------------------------------------

  template <typename ForwardIterator1, typename ForwardIterator2>
  ForwardIterator1
  search(ForwardIterator1 begin1, ForwardIterator1 end1,
	 ForwardIterator2 begin2, ForwardIterator2 end2)
  {
    typedef typename cool::iterator_traits<ForwardIterator1>::key_type T1;
    typedef typename cool::iterator_traits<ForwardIterator2>::key_type T2;

    return cool::search(begin1, end1, begin2, end2, cool::equal_to<T1, T2>());
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_SEARCH_HPP */
