// -*-C++-*- include/cool/algorithm/replace_copy.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   the replace_copy() family of algorithms
// Version: $Id: replace_copy.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_REPLACE_COPY_HPP)
#define COOL_ALGORITHM_REPLACE_COPY_HPP 1

#if !defined(COOL_ALGORITHM_TRANSFORM_HPP)
#  include "cool/algorithm/transform.hpp"
#endif
#if !defined(COOL_PROPERTY_IDENTITY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_BIND_HPP)
#  include "cool/functional/bind.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_EQUAL_TO_HPP)
#  include "cool/functional/equal_to.hpp"
#endif

namespace cool
{

  // ------------------------------------------------------------------------

  template <typename UnaryPredicate, typename T>
  struct replace_copy_if_functor_t
  {
    replace_copy_if_functor_t(UnaryPredicate const& pred, T const& val): m_pred(pred), m_value(val) {}
    T operator()(T const& val) const { return m_pred(val)? m_value: val; }
    T operator()(T const& val)       { return m_pred(val)? m_value: val; }
    UnaryPredicate m_pred;
    T              m_value;
  };

  template <typename UnaryPredicate, typename T>
  inline replace_copy_if_functor_t<UnaryPredicate, T>
  replace_copy_if_functor(UnaryPredicate const& pred, T const& val)
  {
    return cool::replace_copy_if_functor_t<UnaryPredicate, T>(pred, val);
  }

  // ------------------------------------------------------------------------

  template <typename InputIterator, typename OutputIterator, typename UnaryPredicate,
	    typename T, typename ReadPM, typename WritePM>
  inline OutputIterator
  replace_copy_if(InputIterator begin1, InputIterator end1,
		  OutputIterator begin2,
		  UnaryPredicate pred,
		  T const& val,
		  ReadPM read_pm, WritePM write_pm)
  {
    return cool::transform(begin1, end1, begin2, cool::replace_copy_if_functor(pred, val), read_pm, write_pm);
  }

  // ------------------------------------------------------------------------

  template <typename InputIterator, typename OutputIterator, typename UnaryPredicate,
	    typename T>
  inline OutputIterator
  replace_copy_if(InputIterator begin1, InputIterator end1,
		  OutputIterator begin2,
		  UnaryPredicate pred,
		  T const& val)
  {
    return cool::replace_copy_if(begin1, end1, begin2, pred, val, cool::identity_map(), cool::identity_map());
  }

  // ------------------------------------------------------------------------

  template <typename InputIterator, typename OutputIterator, typename T,
	    typename ReadPM, typename WritePM>
  inline OutputIterator
  replace_copy(InputIterator begin1, InputIterator end1,
	       OutputIterator begin2,
	       T const& old,
	       T const& val,
	       ReadPM read_pm, WritePM write_pm)
  {
    return cool::replace_copy_if(begin1, end1, begin2, cool::bind2nd(cool::equal_to<T>(), old), val, read_pm, write_pm);
  }

  // ------------------------------------------------------------------------

  template <typename InputIterator, typename OutputIterator, typename T>
  inline OutputIterator
  replace_copy(InputIterator begin1, InputIterator end1,
		  OutputIterator begin2,
		  T const& old,
		  T const& val)
  {
    return cool::replace_copy_if(begin1, end1, begin2, cool::bind2nd(cool::equal_to<T>(), old), val);
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_REPLACE_COPY_HPP */
