// -*-C++-*- include/cool/algorithm/replace.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   the replace() family of algorithms
// Version: $Id: replace.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_REPLACE_HPP)
#define COOL_ALGORITHM_REPLACE_HPP 1

#if !defined(COOL_ALGORITHM_FIND_HPP)
#  include "cool/algorithm/find.hpp"
#endif
#if !defined(COOL_PROPERTY_IDENTY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_EQUAL_TO_HPP)
#  include "cool/functional/equal_to.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_BIND_HPP)
#  include "cool/functional/bind.hpp"
#endif

namespace cool
{

  // ------------------------------------------------------------------------

  template <typename ForwardIterator, typename UnaryPredicate, typename T,
	    typename ReadPM, typename WritePM>
  inline void
  replace_if(ForwardIterator begin, ForwardIterator end, UnaryPredicate pred,
	     T const& value, ReadPM read_pm, WritePM write_pm)
  {
    for (; (begin = cool::find_if(begin, end, pred, read_pm)) != end; ++begin)
      put(write_pm, *begin, value);
  }

  // ------------------------------------------------------------------------

  template <typename ForwardIterator, typename UnaryPredicate, typename T>
  inline void
  replace_if(ForwardIterator begin, ForwardIterator end, UnaryPredicate pred,
	     T const& value)
  {
    cool::replace_if(begin, end, pred, value, cool::identity_map(), cool::identity_map());
  }

  // ------------------------------------------------------------------------

  template <typename ForwardIterator, typename UnaryPredicate, typename T,
	    typename ReadWritePM>
  inline void
  replace_if(ForwardIterator begin, ForwardIterator end, UnaryPredicate pred,
	     T const& value, ReadWritePM read_write_pm)
  {
    cool::replace_if(begin, end, pred, value, read_write_pm, read_write_pm);
  }

  // ------------------------------------------------------------------------

  template <typename ForwardIterator, typename T, typename ReadPM, typename WritePM>
  inline void
  replace(ForwardIterator begin, ForwardIterator end, T const& old,
	  T const& value, ReadPM read_pm, WritePM write_pm)
  {
    cool::replace_if(begin, end, cool::bind2nd(cool::equal_to<T>(), old), value, read_pm, write_pm);
  }

  // ------------------------------------------------------------------------

  template <typename ForwardIterator, typename T, typename ReadWritePM>
  inline void
  replace(ForwardIterator begin, ForwardIterator end, T const& old,
	  T const& value, ReadWritePM read_write_pm)
  {
    cool::replace_if(begin, end, cool::bind2nd(cool::equal_to<T>(), old), value, read_write_pm, read_write_pm);
  }

  // ------------------------------------------------------------------------

  template <typename ForwardIterator, typename T>
  inline void
  replace(ForwardIterator begin, ForwardIterator end, T const& old, T const& value)
  {
    cool::replace(begin, end, old, value, cool::identity_map(), cool::identity_map());
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_REPLACE_HPP */
