// -*-C++-*- include/cool/algorithm/remove_copy.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   the remove_copy() family of algorithms
// Version: $Id: remove_copy.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORTIHM_REMOVE_COPY_HPP)
#define COOL_ALGORTIHM_REMOVE_COPY_HPP 1

#if !defined(COOL_ALGORTIHM_FOR_EACH_HPP)
#  include "cool/algorithm/for_each.hpp"
#endif
#if !defined(COOL_PROPERTY_IDENTITY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif
#if !defined(COOL_TRAITS_ITERATOR_HPP)
#  include "cool/traits/iterator.hpp"
#endif
#if !defined(COOL_TRAITS_PROPERTY_HPP)
#  include "cool/traits/property.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_EQUAL_TO_HPP)
#  include "cool/functional/equal_to.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_BIND_HPP)
#  include "cool/functional/bind.hpp"
#endif

namespace cool
{

  // ------------------------------------------------------------------------

  template <typename OutputIterator, typename Predicate, typename WritePM>
  struct remove_copy_if_functor
  {
    remove_copy_if_functor(OutputIterator const& it, Predicate const& pred, WritePM const& pm):
      iterator(it), predicate(pred), write_pm(pm)
      {
      }
    template <typename T>
    void operator()(T const& val)
      {
	if (!predicate(val))
	{
	  put(write_pm, *iterator, val);
	  ++iterator;
	}
      }

    OutputIterator iterator;
    Predicate      predicate;
    WritePM        write_pm;
  };

  // ------------------------------------------------------------------------

  template <typename InputIterator, typename OutputIterator, typename Predicate,
	    typename ReadPM, typename WritePM>
  inline OutputIterator
  remove_copy_if(InputIterator begin1, InputIterator end1,
		 OutputIterator begin2,
		 Predicate pred,
		 ReadPM read_pm, WritePM write_pm)
  {
    return cool::for_each(begin1, end1,
			  cool::remove_copy_if_functor<OutputIterator, Predicate, WritePM>(begin2, pred, write_pm),
			  read_pm).iterator;
  }

  // ------------------------------------------------------------------------

  template <typename InputIterator, typename OutputIterator, typename Predicate>
  inline OutputIterator
  remove_copy_if(InputIterator begin1, InputIterator end1,
		 OutputIterator begin2,
		 Predicate pred)
  {
    return cool::remove_copy_if(begin1, end1, begin2, pred, cool::identity_map(), cool::identity_map());
  }

  // ------------------------------------------------------------------------

  template <typename InputIterator, typename OutputIterator, typename Value,
	    typename ReadPM, typename WritePM>
  inline OutputIterator
  remove_copy(InputIterator begin1, InputIterator end1,
	      OutputIterator begin2,
	      Value const& value,
	      ReadPM read_pm, WritePM write_pm)
  {
    typedef typename cool::iterator_traits<InputIterator>::key_type key_type;
    typedef typename cool::property_use_traits<ReadPM, key_type>::value_type value_type;
    return cool::remove_copy_if(begin1, end1, begin2, cool::bind2nd(cool::equal_to<value_type, Value>(), value), read_pm, write_pm);
  }

  // ------------------------------------------------------------------------

  template <typename InputIterator, typename OutputIterator, typename Value>
  inline OutputIterator
  remove_copy(InputIterator begin1, InputIterator end1,
	      OutputIterator begin2,
	      Value const& value)
  {
    return cool::remove_copy(begin1, end1, begin2, value, cool::identity_map(), cool::identity_map());
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORTIHM_REMOVE_COPY_HPP */
