// -*-C++-*- include/cool/algorithm/push_heap.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   the push_heap() family of algorithms
// Version: $Id: push_heap.hpp,v 1.1.1.1 2003/01/07 00:15:07 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_PUSH_HEAP_HPP)
#define COOL_ALGORITHM_PUSH_HEAP_HPP 1

#if !defined(COOL_ALGORITHM_ITER_SWAP_HPP)
#  include "cool/algorithm/iter_swap.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_LESS_HPP)
#  include "cool/functional/less.hpp"
#endif
#if !defined(COOL_TRAITS_PROPERTY_HPP)
#  include "cool/traits/property.hpp"
#endif
#if !defined(COOL_PROPERTY_IDENITY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif
#include <cassert>

namespace cool
{

  // ------------------------------------------------------------------------

  template <typename RandomAccessIterator, typename BinaryPredicate,
	    typename ReadPM, typename ReadWritePM>
  void
  push_heap(RandomAccessIterator begin, RandomAccessIterator end,
	    BinaryPredicate pred,
	    ReadPM read_pm, ReadWritePM readwrite_pm)
  {
    typedef typename cool::iterator_traits<RandomAccessIterator>::difference_type difference_type;

    for (difference_type n = (end - begin - 1), p = (n - 1) / 2;
	 n != 0 && pred(get(read_pm, begin[p]), get(read_pm, begin[n]));
	 n = p, p = (n - 1) / 2)
      cool::iter_swap(begin + p, begin + n, readwrite_pm, readwrite_pm);
  }

  // ------------------------------------------------------------------------

  template <typename RandomAccessIterator, typename BinaryPredicate,
	    typename ReadWritePM>
  inline void
  push_heap(RandomAccessIterator begin, RandomAccessIterator end,
	    BinaryPredicate pred,
	    ReadWritePM readwrite_pm, cool::false_t const&)
  {
    push_heap(begin, end, pred, readwrite_pm, readwrite_pm);
  }

  template <typename RandomAccessIterator,
	    typename ReadPM, typename ReadWritePM>
  inline void
  push_heap(RandomAccessIterator begin, RandomAccessIterator end,
	    ReadPM read_pm, ReadWritePM readwrite_pm, cool::true_t const&)
  {
    typedef typename property_traits<ReadPM, RandomAccessIterator>::value_type value_type;
    push_heap(begin, end, cool::less<value_type>(), read_pm, readwrite_pm);
  }

  template <typename RandomAccessIterator, typename T, typename PM>
  inline void
  push_heap(RandomAccessIterator begin, RandomAccessIterator end,
	    T t, PM pm)
  {
    push_heap(begin, end, t, pm, typename cool::is_read_pm<T, RandomAccessIterator>::type());
  }

  // ------------------------------------------------------------------------

  template <typename RandomAccessIterator, typename BinaryPredicate>
  inline void
  push_heap(RandomAccessIterator begin, RandomAccessIterator end,
	    BinaryPredicate pred, cool::false_t const&)
  {
    push_heap(begin, end, pred, cool::identity_map());
  }

  template <typename RandomAccessIterator, typename ReadWritePM>
  inline void
  push_heap(RandomAccessIterator begin, RandomAccessIterator end,
	    ReadWritePM readwrite_pm, cool::true_t const&)
  {
    typedef typename property_traits<ReadWritePM, RandomAccessIterator>::value_type value_type;
    push_heap(begin, end, cool::less<value_type>(), readwrite_pm, readwrite_pm);
  }

  template <typename RandomAccessIterator, typename T>
  inline void
  push_heap(RandomAccessIterator begin, RandomAccessIterator end, T t)
  {
    push_heap(begin, end, t, typename cool::is_read_pm<T, RandomAccessIterator>::type());
  }

  // ------------------------------------------------------------------------

  template <typename RandomAccessIterator>
  inline void
  push_heap(RandomAccessIterator begin, RandomAccessIterator end)
  {
    push_heap(begin, end, cool::identity_map());
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_PUSH_HEAP_HPP */
