// -*-C++-*- include/cool/algorithm/partition.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   the partition() family of algorithms
// Version: $Id: partition.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_PARTITION_HPP)
#define COOL_ALGORITHM_PARTITION_HPP 1

#if !defined(COOL_ALGORITHM_ITER_SWAP_HPP)
#  include "cool/algorithm/iter_swap.hpp"
#endif
#if !defined(COOL_ALGORITHM_FIND_HPP)
#  include "cool/algorithm/find.hpp"
#endif
#if !defined(COOL_ALGORITHM_NEXT_HPP)
#  include "cool/algorithm/next.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_LESS_HPP)
#  include "cool/functional/not.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_LESS_HPP)
#  include "cool/functional/less.hpp"
#endif
#if !defined(COOL_TRAITS_PROPERTY_HPP)
#  include "cool/traits/property.hpp"
#endif
#if !defined(COOL_PROPERTY_IDENITY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif

namespace cool
{

  //-dk:TODO move to the correct place...
  template <typename BidirectionalIterator>
  inline std::reverse_iterator<BidirectionalIterator>
  make_reverse(BidirectionalIterator it)
  {
    return std::reverse_iterator<BidirectionalIterator>(it);
  }

  // ------------------------------------------------------------------------

  template <typename BidirectionalIterator, typename Predicate,
	    typename ReadPM, typename ReadWritePM>
  BidirectionalIterator
  partition(BidirectionalIterator begin, BidirectionalIterator end,
	    Predicate pred,
	    ReadPM read_pm, ReadWritePM readwrite_pm)
  {
    while (begin != end)
    {
      begin = cool::find_if(begin, end, cool::not1(pred), read_pm);
      end = cool::find_if(cool::make_reverse(end), cool::make_reverse(begin), pred, read_pm).base();
      
      if (begin != end && begin != --end)
      {
	cool::iter_swap(begin, end, readwrite_pm, readwrite_pm);
	// ++begin;
      }
    }
    return begin;
  }

  // ------------------------------------------------------------------------

  template <typename BidirectionalIterator, typename Predicate,
	    typename ReadWritePM>
  inline BidirectionalIterator
  partition(BidirectionalIterator begin, BidirectionalIterator end,
	    Predicate pred,
	    ReadWritePM readwrite_pm)
  {
    return partition(begin, end, pred, readwrite_pm, readwrite_pm);
  }

  // ------------------------------------------------------------------------

  template <typename BidirectionalIterator, typename Predicate>
  inline BidirectionalIterator
  partition(BidirectionalIterator begin, BidirectionalIterator end,
	    Predicate pred)
  {
    return partition(begin, end, pred, cool::identity_map());
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_PARTITION_HPP */
