// -*-C++-*- include/cool/algorithm/mismatch.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   mismatch() family of algorithms
// Version: $Id: mismatch.hpp,v 1.1.1.1 2003/01/07 00:15:07 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_MISMATCH_HPP)
#define COOL_ALGORITHM_MISMATCH_HPP 1

#if !defined(COOL_FUNCTIONAL_EQUAL_TO_HPP)
#  include "cool/functional/equal_to.hpp"
#endif
#if !defined(COOL_PROPERTY_IDENTITY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif
#if !defined(COOL_TRAITS_ITERATOR_HPP)
#  include "cool/traits/iterator.hpp"
#endif
#if !defined(COOL_TRAITS_PROPERTY_HPP)
#  include "cool/traits/property.hpp"
#endif

#include <utility> //-dk:TODO remove

namespace cool
{

  // ------------------------------------------------------------------------
  // workhorse: mismatch()

  template <typename InputIterator1, typename InputIterator2, typename BinaryPredicate,
	    typename ReadPM1, typename ReadPM2>
  std::pair<InputIterator1, InputIterator2>
  mismatch(InputIterator1 begin1, InputIterator1 end1,
	   InputIterator2 begin2,
	   BinaryPredicate pred,
	   ReadPM1 pm1, ReadPM2 pm2)
  {
    while (begin1 != end1 && pred(get(pm1, *begin1), get(pm2, *begin2)))
    {
      ++begin1;
      ++begin2;
    }
    return std::make_pair(begin1, begin2);
  }

  // ------------------------------------------------------------------------
  // deprecated:

  template <typename InputIterator1, typename InputIterator2, typename BinaryPredicate>
  inline std::pair<InputIterator1, InputIterator2>
  mismatch(InputIterator1 begin1, InputIterator1 end1,
	   InputIterator2 begin2,
	   BinaryPredicate pred)
  {
    return cool::mismatch(begin1, end1, begin2, pred, cool::identity_map(), cool::identity_map());
  }

  // ------------------------------------------------------------------------

  template <typename InputIterator1, typename InputIterator2,
	    typename ReadPM1, typename ReadPM2>
  inline std::pair<InputIterator1, InputIterator2>
  mismatch(InputIterator1 begin1, InputIterator1 end1,
	   InputIterator2 begin2,
	   ReadPM1 pm1, ReadPM2 pm2)
  {
    typedef typename cool::property_use_traits<ReadPM1, typename cool::iterator_traits<InputIterator1>::key_type>::value_type T1;
    typedef typename cool::property_use_traits<ReadPM2, typename cool::iterator_traits<InputIterator2>::key_type>::value_type T2;

    return cool::mismatch(begin1, end1, begin2, cool::equal_to<T1, T2>(), pm1, pm2);
  }

  // ------------------------------------------------------------------------
  // deprecated:

  template <typename InputIterator1, typename InputIterator2>
  inline std::pair<InputIterator1, InputIterator2>
  mismatch(InputIterator1 begin1, InputIterator1 end1,
	   InputIterator2 begin2)
  {
    return cool::mismatch(begin1, end1, begin2,
			  cool::equal_to<typename std::iterator_traits<InputIterator1>::value_type,
		                         typename std::iterator_traits<InputIterator2>::value_type>());
  }

  // ------------------------------------------------------------------------
  // ------------------------------------------------------------------------
  // workhorse: mismatch()
  //-dk:TODO optimize for random access iterators: use three iterator version!

  template <typename InputIterator1, typename InputIterator2, typename BinaryPredicate,
	    typename ReadPM1, typename ReadPM2>
  std::pair<InputIterator1, InputIterator2>
  mismatch(InputIterator1 begin1, InputIterator1 end1,
	   InputIterator2 begin2, InputIterator2 end2,
	   BinaryPredicate pred,
	   ReadPM1 pm1, ReadPM2 pm2)
  {
    while (begin1 != end1 && begin2 != end2 && pred(get(pm1, *begin1), get(pm2, *begin2)))
    {
      ++begin1;
      ++begin2;
    }
    return std::make_pair(begin1, begin2);
  }

  // ------------------------------------------------------------------------

  template <typename InputIterator1, typename InputIterator2,
	    typename ReadPM1, typename ReadPM2>
  std::pair<InputIterator1, InputIterator2>
  mismatch(InputIterator1 begin1, InputIterator1 end1,
	   InputIterator2 begin2, InputIterator2 end2,
	   ReadPM1 pm1, ReadPM2 pm2)
  {
    typedef typename cool::property_use_traits<ReadPM1, typename cool::iterator_traits<InputIterator1>::key_type>::value_type T1;
    typedef typename cool::property_use_traits<ReadPM2, typename cool::iterator_traits<InputIterator2>::key_type>::value_type T2;

    return cool::mismatch(begin1, end1, begin2, end2, cool::equal_to<T1, T2>(), pm1, pm2);
  }

  // ------------------------------------------------------------------------

  template <typename InputIterator1, typename InputIterator2, typename BinaryPredicate>
  inline std::pair<InputIterator1, InputIterator2>
  mismatch(InputIterator1 begin1, InputIterator1 end1,
	   InputIterator2 begin2, InputIterator2 end2,
	   BinaryPredicate pred)
  {
    return cool::mismatch(begin1, end1, begin2, end2, pred, cool::identity_map(), cool::identity_map());
  }

  // ------------------------------------------------------------------------

  template <typename InputIterator1, typename InputIterator2>
  inline std::pair<InputIterator1, InputIterator2>
  mismatch(InputIterator1 begin1, InputIterator1 end1,
	   InputIterator2 begin2, InputIterator2 end2)
  {
    return cool::mismatch(begin1, end1, begin2, end2,
			  cool::equal_to<typename std::iterator_traits<InputIterator1>::value_type,
			  typename std::iterator_traits<InputIterator2>::value_type>());
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_MISMATCH_HPP */
