// -*-C++-*- include/cool/algorithm/min.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   the min() family of algorithms
// Version: $Id: min.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_MIN_HPP)
#define COOL_ALGORITHM_MIN_HPP 1

#if !defined(COOL_FUNCTIONAL_LESS_HPP)
#  include "cool/functional/less.hpp"
#endif

namespace cool
{

  // ------------------------------------------------------------------------

  template <typename T, typename Pred>
  inline T const&
  min(T const& v1, T const& v2, Pred pred)
  {
    return pred(v1, v2)? v1: v2;
  }

  // ------------------------------------------------------------------------

  template <typename T>
  inline T const&
  min(T const& v1, T const& v2)
  {
    return cool::min(v1, v2, cool::less<T>());
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_MIN_HPP */
