// -*-C++-*- include/cool/algorithm/merge.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   the merge() family of algorithms
// Version: $Id: merge.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_MERGE_HPP)
#define COOL_ALGORITHM_MERGE_HPP 1

#if !defined(COOL_ALGORITHM_COPY_HPP)
#  include "cool/algorithm/copy.hpp"
#endif
#if !defined(COOL_PROPERTY_IDENTITY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif
#if !defined(COOL_TRAITS_PROPERTY_HPP)
#  include "cool/traits/property.hpp"
#endif
#if !defined(COOL_TRAITS_ITERATOR_HPP)
#  include "cool/traits/iterator.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_LESS_HPP)
#  include "cool/functional/less.hpp"
#endif

namespace cool
{

  // ------------------------------------------------------------------------
  // workhorse: merge()

  template <typename InputIterator1, typename InputIterator2, typename OutputIterator,
	    typename BinaryPredicate,
	    typename ReadPM1, typename ReadPM2, typename WritePM,
	    typename CopyPM1, typename CopyPM2>
  OutputIterator
  merge(InputIterator1 begin1, InputIterator1 end1,
	InputIterator2 begin2, InputIterator2 end2,
	OutputIterator begin3,
	BinaryPredicate pred,
	ReadPM1 read_pm1, ReadPM2 read_pm2,
	WritePM write_pm,
	CopyPM1 copy_pm1, CopyPM2 copy_pm2)
  {
    for (; begin1 != end1 && begin2 != end2; ++begin3)
      if (pred(get(read_pm2, *begin2), get(read_pm1, *begin1)))
      {
	put(write_pm, *begin3, get(copy_pm2, *begin2));
	++begin2;
      }
      else
      {
	put(write_pm, *begin3, get(copy_pm1, *begin1));
	++begin1;
      }

    return begin1 != end1? cool::copy(begin1, end1, begin3, copy_pm1, write_pm): cool::copy(begin2, end2, begin3, copy_pm2, write_pm);
  }

  // ------------------------------------------------------------------------

  template <typename InputIterator1, typename InputIterator2, typename OutputIterator,
	    typename ReadPM1, typename ReadPM2, typename WritePM,
	    typename CopyPM1, typename CopyPM2>
  OutputIterator
  merge(InputIterator1 begin1, InputIterator1 end1,
	    InputIterator2 begin2, InputIterator2 end2,
	    OutputIterator begin3,
	    ReadPM1 read_pm1, ReadPM2 read_pm2,
	    WritePM write_pm,
	    CopyPM1 copy_pm1, CopyPM2 copy_pm2)
  {
    typedef typename cool::iterator_traits<InputIterator1>::key_type          key_type;
    typedef typename cool::property_use_traits<ReadPM1, key_type>::value_type value_type;

    return cool::merge(begin1, end1, begin2, end2, begin3, cool::less<value_type>(), read_pm1, read_pm2, write_pm, copy_pm1, copy_pm2);
  }

  // ------------------------------------------------------------------------

  template <typename InputIterator1, typename InputIterator2, typename OutputIterator,
	    typename BinaryPredicate,
	    typename ReadPM1, typename ReadPM2, typename WritePM>
  OutputIterator
  merge(InputIterator1 begin1, InputIterator1 end1,
	    InputIterator2 begin2, InputIterator2 end2,
	    OutputIterator begin3,
	    BinaryPredicate pred,
	    ReadPM1 read_pm1, ReadPM2 read_pm2,
	    WritePM write_pm)
  {
    return cool::merge(begin1, end1, begin2, end2, begin3, pred, read_pm1, read_pm2, write_pm, read_pm1, read_pm2);
  }

  // ------------------------------------------------------------------------

  template <typename InputIterator1, typename InputIterator2, typename OutputIterator,
	    typename ReadPM1, typename ReadPM2, typename WritePM>
  OutputIterator
  merge(InputIterator1 begin1, InputIterator1 end1,
	    InputIterator2 begin2, InputIterator2 end2,
	    OutputIterator begin3,
	    ReadPM1 read_pm1, ReadPM2 read_pm2,
	    WritePM write_pm)
  {
    return cool::merge(begin1, end1, begin2, end2, begin3, read_pm1, read_pm2, write_pm, read_pm1, read_pm2);
  }

  // ------------------------------------------------------------------------

  template <typename InputIterator1, typename InputIterator2, typename OutputIterator,
	    typename BinaryPredicate>
  OutputIterator
  merge(InputIterator1 begin1, InputIterator1 end1,
	    InputIterator2 begin2, InputIterator2 end2,
	    OutputIterator begin3,
	    BinaryPredicate pred)
  {
    cool::identity_map pm;
    return cool::merge(begin1, end1, begin2, end2, begin3, pred, pm, pm, pm);
  }

  // ------------------------------------------------------------------------

  template <typename InputIterator1, typename InputIterator2, typename OutputIterator>
  OutputIterator
  merge(InputIterator1 begin1, InputIterator1 end1,
	    InputIterator2 begin2, InputIterator2 end2,
	    OutputIterator begin3)
  {
    cool::identity_map pm;
    return cool::merge(begin1, end1, begin2, end2, begin3, pm, pm, pm);
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_MERGE_HPP */
