// -*-C++-*- include/cool/algorithm/max_element.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   the max_element() family of algorithms
// Version: $Id: max_element.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_MAX_ELEMENT_HPP)
#define COOL_ALGORITHM_MAX_ELEMENT_HPP 1

#if !defined(COOL_ALGORITHM_MIN_ELEMENT_HPP)
#  include "cool/algorithm/min_element.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_REVERSE_ARGUMENTS_HPP)
#  include "cool/functional/reverse_arguments.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_LESS_HPP)
#  include "cool/functional/less.hpp"
#endif
#if !defined(COOL_PROPERTY_IDENTITY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif
#if !defined(COOL_TRAITS_ITERATOR_HPP)
#  include "cool/traits/iterator.hpp"
#endif
#if !defined(COOL_TRAITS_PROPERTY_HPP)
#  include "cool/traits/property.hpp"
#endif

namespace cool
{

  // ------------------------------------------------------------------------

  template <typename ForwardIterator, typename Pred, typename ReadPM>
  ForwardIterator
  max_element(ForwardIterator begin, ForwardIterator end, Pred pred, ReadPM pm)
  {
    return cool::min_element(begin, end, cool::reverse_arguments(pred), pm);
  }

  // ------------------------------------------------------------------------

  namespace max_element_aux
  {
    struct aux {};
    typedef char char1[1];
    typedef char char2[2];

    template <typename T> char1& aux_func(T const&);
    char2& aux_func(aux const&);

    template <typename S, typename T> aux get(S const&, T const&, ...);
    template <typename T> T& get_ref();

    template <typename T, typename ForwardIterator>
    struct is_read_pm
    {
      enum { val = sizeof(aux_func(get(get_ref<T>(), *get_ref<ForwardIterator>()))) };
    };

    template <int i> struct call {
      template <typename ForwardIterator, typename Pred>
      static inline ForwardIterator
      max_element(ForwardIterator begin, ForwardIterator end, Pred pred)
      {
	return cool::max_element(begin, end, pred, cool::identity_map());
      }
    };

    template <> struct call<sizeof(char1)> {
      template <typename ForwardIterator, typename ReadPM>
      static inline ForwardIterator
      max_element(ForwardIterator begin, ForwardIterator end, ReadPM pm)
      {
	typedef typename cool::iterator_traits<ForwardIterator>::key_type key_type;
	typedef typename cool::property_use_traits<ReadPM, key_type>::value_type value_type;
	
	return cool::max_element(begin, end, cool::less<value_type>(), pm);
      }
    };
  }

  template <typename ForwardIterator, typename T>
  inline ForwardIterator
  max_element(ForwardIterator begin, ForwardIterator end, T t)
  {
    typedef max_element_aux::call<max_element_aux::is_read_pm<T, ForwardIterator>::val> call_type;
    return call_type::max_element(begin, end, t);
  }

  // ------------------------------------------------------------------------

  template <typename ForwardIterator>
  inline ForwardIterator
  max_element(ForwardIterator begin, ForwardIterator end)
  {
    return cool::max_element(begin, end, cool::identity_map());
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_MAX_ELEMENT_HPP */
