// -*-C++-*- include/cool/algorithm/lower_bound.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   the lower_bound() family of algorithms
// Version: $Id: lower_bound.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_LOWER_BOUND_HPP)
#define COOL_ALGORITHM_LOWER_BOUND_HPP 1

#if !defined(COOL_ALGORITHM_DISTANCE_HPP)
#  include "cool/algorithm/distance.hpp"
#endif
#if !defined(COOL_PROPERTY_IDENTITY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_LESS_HPP)
#  include "cool/functional/less.hpp"
#endif
#if !defined(COOL_TRAITS_PROPERTY_HPP)
#  include "cool/traits/property.hpp"
#endif

namespace cool
{

  // ------------------------------------------------------------------------
  // workhorse: lower_bound()

  template <typename RandomAccessIterator, typename T, typename BinaryPredicate, typename ReadPM>
  RandomAccessIterator
  lower_bound(RandomAccessIterator begin, RandomAccessIterator end, T const& val,
	      BinaryPredicate pred,
	      ReadPM read_pm)
  {
    typedef typename cool::iterator_traits<RandomAccessIterator>::difference_type difference_type;
    for (difference_type len = cool::distance(begin, end); (len = cool::distance(begin, end)) > 0; )
    {
      len /= 2;
      RandomAccessIterator middle = begin + len;
      //std::cout << "len: " << len << "  *middle: " << *middle << " val: " << val << "\n";
      if (pred(get(read_pm, *middle), val))
	begin = ++middle;
      else
	end = middle;
    }

    return begin;
  }

  // ------------------------------------------------------------------------

  template <typename RandomAccessIterator, typename T, typename BinaryPredicate>
  inline RandomAccessIterator
  lower_bound(RandomAccessIterator begin, RandomAccessIterator end, T const& val,
	      BinaryPredicate pred, cool::false_t)
  {
    return cool::lower_bound(begin, end, val, pred, cool::identity_map());
  }

  template <typename RandomAccessIterator, typename T, typename ReadPM>
  inline RandomAccessIterator
  lower_bound(RandomAccessIterator begin, RandomAccessIterator end, T const& val,
	      ReadPM read_pm, cool::true_t)
  {
    typedef typename cool::iterator_traits<RandomAccessIterator>::key_type   key_type;
    typedef typename cool::property_use_traits<ReadPM, key_type>::value_type value_type;

    return cool::lower_bound(begin, end, val, cool::less<value_type>(), read_pm);
  }

  template <typename RandomAccessIterator, typename T, typename S>
  inline RandomAccessIterator
  lower_bound(RandomAccessIterator begin, RandomAccessIterator end, T const& val, S s)
  {
    return cool::lower_bound(begin, end, val, s, typename cool::is_read_pm<S, RandomAccessIterator>::type());
  }

  // ------------------------------------------------------------------------

  template <typename RandomAccessIterator, typename T>
  inline RandomAccessIterator
  lower_bound(RandomAccessIterator begin, RandomAccessIterator end, T const& val)
  {
    return cool::lower_bound(begin, end, val, cool::identity_map());
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_LOWER_BOUND_HPP */
