// -*-C++-*- include/cool/algorithm/heap_operation.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   auxiliay heap operations used from multiple algorithms
// Version: $Id: heap_operation.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_HEAP_OPERATION_HPP)
#define COOL_ALGORITHM_HEAP_OPERATION_HPP 1

#if !defined(COOL_ALGORITHM_ITER_SWAP_HPP)
#  include "cool/algorithm/iter_swap.hpp"
#endif
#if !defined(COOL_TRAITS_ITERATOR_HPP)
#  include "cool/traits/iterator.hpp"
#endif

namespace cool
{

  // ------------------------------------------------------------------------

  template <typename RandomAccessIterator,
	    typename BinaryPredicate,
	    typename ReadPM, typename ReadWritePM>
  void
  heapify(RandomAccessIterator begin, RandomAccessIterator end,
	  RandomAccessIterator element,
	  BinaryPredicate pred,
	  ReadPM read_pm, ReadWritePM readwrite_pm)
  {
    enum { d = 2 };
    typedef typename cool::iterator_traits<RandomAccessIterator>::difference_type difference_type;

    difference_type length = end - begin;
    difference_type current = element - begin;
    difference_type tmp = current;

    for (difference_type min = current; (tmp = current * d + d) < length; current = min)
    {
      for (difference_type i = 0; i < d; ++i)
      {
	if (pred(get(read_pm, begin[min]), get(read_pm, begin[tmp - i])))
	{
	  min = tmp - i;
	}
      }

      if (min == current)
	return;

      cool::iter_swap(begin + current, begin + min, readwrite_pm, readwrite_pm);
    }

    if (tmp == length
	&& pred(get(read_pm, begin[current]), get(read_pm, begin[tmp - 1])))
    {
      cool::iter_swap(begin + current, begin + tmp - 1, readwrite_pm, readwrite_pm);
    }
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_HEAP_OPERATION_HPP */
