// -*-C++-*- include/cool/algorithm/generate.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   the generate() family fo algorithms
// Version: $Id: generate.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_GENERATE_HPP)
#define COOL_ALGORITHM_GENERATE_HPP 1

#if !defined(COOL_PROPERTY_IDENTITY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif

namespace cool
{

  // ------------------------------------------------------------------------
  // workhorse: generate()
  
  template <typename ForwardIterator, typename Generator, typename WritePM>
  void
  generate(ForwardIterator begin, ForwardIterator end, Generator generator,
	   WritePM pm)
  {
    for (; begin != end; ++begin)
      put(pm, *begin, generator());
  }

  // ------------------------------------------------------------------------
  
  template <typename ForwardIterator, typename Generator>
  inline void
  generate(ForwardIterator begin, ForwardIterator end, Generator generator)
  {
    return cool::generate(begin, end, generator, cool::identity_map());
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_GENERATE_HPP */
