// -*-C++-*- include/cool/algorithm/fill.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   the fill() family of algorithms
// Version: $Id: fill.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_FILL_HPP)
#define COOL_ALGORITHM_FILL_HPP 1

#if !defined(COOL_ALGORITHM_GENERATE_HPP)
#  include "cool/algorithm/generate.hpp"
#endif

#if !defined(COOL_PROPERTY_IDENTITY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_CONSTANT_HPP)
#  include "cool/functional/constant.hpp"
#endif

namespace cool
{

  // ------------------------------------------------------------------------

  template <typename ForwardIterator, typename T, typename WritePM>
  inline void
  fill(ForwardIterator begin, ForwardIterator end, T const& val, WritePM pm)
  {
    cool::generate(begin, end, cool::constant(val), pm);
  }

  // ------------------------------------------------------------------------

  template <typename ForwardIterator, typename T>
  inline void
  fill(ForwardIterator begin, ForwardIterator end, T const& val)
  {
    cool::fill(begin, end, val, cool::identity_map());
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_FILL_HPP */
