// -*-C++-*- include/cool/algorithm/count.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   count() family of algorithms
// Version: $Id: count.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_COUNT_HPP)
#define COOL_ALGORITHM_COUNT_HPP 1

#if !defined(COOL_ALGORITHM_FIND_HPP)
#  include "cool/algorithm/find.hpp"
#endif
#if !defined(COOL_PROPERTY_IDENTITY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif

#include <iterator> //-dk:TODO remove
#include <functional> //-dk:TODO remove

namespace cool
{

  // ------------------------------------------------------------------------
  // The effective work on the sequence is done by find_if():

  template <typename InputIterator, typename UnaryPredicate, typename ReadPM>
  typename std::iterator_traits<InputIterator>::difference_type
  count_if(InputIterator begin, InputIterator end,
	   UnaryPredicate pred,
	   ReadPM pm)
  {
    typedef typename std::iterator_traits<InputIterator>::difference_type RC;
    RC rc = RC();

    for(; (begin = cool::find_if(begin, end, pred, pm)) != end; ++begin)
      ++rc;

    return rc;
  }

  // ------------------------------------------------------------------------
  // deprecated

  template <typename InputIterator, typename UnaryPredicate>
  inline typename std::iterator_traits<InputIterator>::difference_type
  count_if(InputIterator begin, InputIterator end, UnaryPredicate pred)
  {
    return cool::count_if(begin, end, pred, cool::identity_map());
  }

  // ------------------------------------------------------------------------

  template <typename InputIterator, typename T, typename ReadPM>
  inline typename std::iterator_traits<InputIterator>::difference_type
  count(InputIterator begin, InputIterator end, T const& val, ReadPM pm)
  {
    return cool::count_if(begin, end, std::bind2nd(std::equal_to<T>(), val), pm);
  }
  
  // ------------------------------------------------------------------------
  // deprecated

  template <typename InputIterator, typename T>
  inline typename std::iterator_traits<InputIterator>::difference_type
  count(InputIterator begin, InputIterator end, T const& val)
  {
    return cool::count_if(begin, end, std::bind2nd(std::equal_to<T>(), val));
  }
  
  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_COUNT_HPP */
