// -*-C++-*- include/cool/algorithm/copy.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   copy algorithms and its variations
// Version: $Id: copy.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_COPY_HPP)
#define COOL_ALGORITHM_COPY_HPP 1

#if !defined(COOL_ALGORITHM_TRANSFORM_HPP)
#  include <cool/algorithm/transform.hpp>
#endif
#if !defined(COOL_PROPERTY_IDENTITY_MAP_HPP)
#  include <cool/property/identity_map.hpp>
#endif
#if !defined(COOL_TRAITS_PROPERTY_HPP)
#  include <cool/traits/property.hpp>
#endif
#if !defined(COOL_TRAITS_TYPE_HPP)
#  include <cool/traits/type.hpp>
#endif
#if !defined(COOL_TRAITS_ITERATOR_HPP)
#  include <cool/traits/iterator.hpp>
#endif
#if !defined(COOL_FUNCTIONAL_IDENTITY_HPP)
#  include <cool/functional/identity.hpp>
#endif

namespace cool
{
  // ------------------------------------------------------------------------

  template <typename InIt, typename OutIt, typename ReadPM, typename WritePM>
  OutIt copy(InIt beg, InIt end, OutIt to, ReadPM read, WritePM write)
  {
    typedef typename cool::type_traits<
      typename cool::property_use_traits<
        ReadPM, typename cool::iterator_traits<InIt>::key_type
        >::value_type
      >::type value_type;
    return cool::transform(beg, end, to, cool::identity<value_type>(), read, write);
  }

  // ------------------------------------------------------------------------
  // convenience interfaces:

  template <typename InIt, typename OutIt, typename ReadPM>
  OutIt copy(InIt beg, InIt end, OutIt to, ReadPM read)
  {
    return cool::copy(beg, end, to, read, cool::identity_map());
  }

  template <typename InIt, typename OutIt>
  OutIt copy(InIt beg, InIt end, OutIt to)
  {
    return cool::copy(beg, end, to, cool::identity_map());
  }

  // ------------------------------------------------------------------------
} // namespace cool

#endif /* COOL_ALGORITHM_COPY_HPP */
