// -*-C++-*- for_each.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2005 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   for_each() with cursors/property map and segment optimization

// ----------------------------------------------------------------------- 

#if !defined(COOL_FOR_EACH_HPP)
#define COOL_FOR_EACH_HPP 1

#include "enable_if.hpp"
#include "segments.hpp"
#include "default_pm.hpp"
#include "is_same.hpp"
#include <algorithm>

namespace cool
{
  // ---------------------------------------------------------------------
  // the default version

  template <typename InCursor, typename ReadPM, typename Func>
  typename cool::enable_if<
      !cool::is_segmented<InCursor>::value
      && !is_same<ReadPM,default_pm>::value
    , Func
  >::type
  for_each(InCursor begin, InCursor end, ReadPM pm, Func func)
  {
    for (; begin != end; ++begin)
      func(pm(*begin));
    return func;
  }

  template <typename InCursor, typename ReadPM, typename Func>
  typename cool::enable_if<
      !cool::is_segmented<InCursor>::value
      && is_same<ReadPM,default_pm>::value
    , Func
  >::type
  for_each(InCursor begin, InCursor end, ReadPM pm, Func func)
  {
      return std::for_each(begin,end,func);
  }

  // ---------------------------------------------------------------------
  // the segmented version

  template <typename InCursor, typename ReadPM, typename Func>
  typename cool::enable_if<cool::is_segmented<InCursor>::value, Func>::type
  for_each(InCursor begin, InCursor end, ReadPM pm, Func func)
  {
    typedef typename cool::segment_cursor<InCursor>::type segment_cursor;
    typename cool::local_cursor<InCursor>::type lbeg = local(begin);

    for (segment_cursor sbeg = segment(begin), send = segment(end);
         sbeg != send; lbeg = local_begin(++sbeg))
      func = for_each(lbeg, local_end(sbeg), pm, func);
    return for_each(local_begin(segment(end)), local(end), pm, func);
  }

  // ---------------------------------------------------------------------
}

#endif /* COOL_FOR_EACH_HPP */
