// -*-C++-*- deque.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2005 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   make deque iterators take advantage of segmentation

// Note: providing segment and local iterators for 'std::deque' depends
//   on the standard library implementation. This file works with gcc's
//   current implementation but probably not with others. It is also
//   incomplete as the segment cursor is only partially defined.
// ----------------------------------------------------------------------- 

#if !defined(COOL_DEQUE_HPP)
#define COOL_DEQUE_HPP 1

#include "segments.hpp"
#include <deque>

// ----------------------------------------------------------------------- 

#if defined(__GNUG__)

namespace cool
{
  template <typename T, typename R, typename P>
  struct is_segmented<std::_Deque_iterator<T, R, P> >
  {
    enum { value = true };
  };

  template <typename T, typename R, typename P>
  struct std_deque_segment_cursor
  {
    std_deque_segment_cursor(std::_Deque_iterator<T, R, P> const& it):
      m_node(it._M_node)
      {
      }

    bool operator== (std_deque_segment_cursor<T, R, P> const& it) const
      {
        return m_node == it.m_node;
      }
    bool operator!= (std_deque_segment_cursor<T, R, P> const& it) const
      {
        return !(*this == it);
      }

    std_deque_segment_cursor& operator++()
      {
        ++m_node;
        return *this;
      }

    T** m_node;
  };

  template <typename T, typename R, typename P>
  T*
  local_begin(std_deque_segment_cursor<T, R, P> const& it)
  {
    return *it.m_node;
  }
  
  template <typename T, typename R, typename P>
  T*
  local_end(std_deque_segment_cursor<T, R, P> const& it)
  {
    return *it.m_node + std::_Deque_iterator<T, R, P>::_S_buffer_size();
  }

  template <typename T, typename R, typename P>
  std::_Deque_iterator<T, R, P>
  make_segmented(std_deque_segment_cursor<T, R, P> const& s, T* l)
  {
    return std::_Deque_iterator<T, R, P>(l, s.m_node);
  }

  template <typename T, typename R, typename P>
  struct segment_cursor<std::_Deque_iterator<T, R, P> >
  {
    typedef std_deque_segment_cursor<T, R, P> type;
  };

  template <typename T, typename R, typename P>
  struct local_cursor<std::_Deque_iterator<T, R, P> >
  {
    typedef T* type;
  };
}

namespace std
{
  template <typename T, typename R, typename P>
  cool::std_deque_segment_cursor<T, R, P>
  segment(std::_Deque_iterator<T, R, P> const& it)
  {
    return cool::std_deque_segment_cursor<T, R, P>(it);
  }

  template <typename T, typename R, typename P>
  T*
  local(std::_Deque_iterator<T, R, P> const& it)
  {
    return it._M_cur;
  }
}
  
#endif

// ----------------------------------------------------------------------- 

#endif /* COOL_DEQUE_HPP */
