// -*-C++-*- default_pm.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2005 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   a property map using the key as its value

// ----------------------------------------------------------------------- 

#if !defined(COOL_DEFAULT_PM_HPP)
#define COOL_DEFAULT_PM_HPP 1

namespace cool
{
  // ---------------------------------------------------------------------
  // a simple property map

  struct default_pm
  {
    template <typename T>
    T const& operator()(T const& k) const { return k; }
    template <typename T>
    T&       operator()(T& k)       const { return k; }
    template <typename T, typename V>
    void     operator()(T& k, V const& v) const { k = v; }
  };

  // ---------------------------------------------------------------------
}

#endif /* COOL_DEFAULT_PM_HPP */
