// -*-C++-*- array_traits.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2005 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   simple function templates to get array boundaries

// ----------------------------------------------------------------------- 

#if !defined(COOL_ARRAY_TRAITS_HPP)
#define COOL_ARRAY_TRAITS_HPP 1

namespace cool
{
  // ---------------------------------------------------------------------

  template <typename T, int sz>
  T* begin(T (&array)[sz])
  {
    return array;
  }

  template <typename T, int sz>
  T* end(T (&array)[sz])
  {
    return array + sz;
  }

  // ---------------------------------------------------------------------
}

#endif /* COOL_ARRAY_TRAITS_HPP */
