#include <iostream.h>
#include <string>

#include "glas.hpp"
#include "algebraic_functions.hpp"

using std::string;

struct stringMonoid_t: glas::def::semiGroupAddOp<string> {
  string identity() {
    return string(); }
} stringMonoid;

int main(int, char* []) {
  string sa("a"), sab("ab"), sbc("bc"), sc("c"), s;
  glas::def::semiGroupAddOp<string>     stringSemiGroup;

  cout << "equalResults(sa, sbc,  sab, sc, stringMonoid) " 
       << equalResults(sa, sbc,  sab, sc, stringMonoid)  << endl;
  cout << "equalResults(sab, sbc,  sab, sc, stringSemiGroup) " 
       << equalResults(sab, sbc,  sab, sc, stringSemiGroup) << endl;

  cout << "identityPair(s, s, stringMonoid) " 
       << identityPair(s, s, stringMonoid)  << endl;
  cout << "identityPair(sa, sa, stringMonoid) " 
       << identityPair(sa, sa, stringMonoid)  << endl;

  cout << "multiplyAndSquare(sab, 13, stringMonoid) "
       << multiplyAndSquare(sab, 13, stringMonoid) << endl;
  return 0;
}
