#include <iostream.h>

#include "glas.hpp"
#include "algebraic_functions.hpp"

bool greaterAbs(float x, float y) {
  return fabs(x) > fabs(y); }

int main(int, char* []) {
  glas::def::groupAddOp<float>                groupAdd;
  glas::def::abelianGroupAddOp<float>         abelAdd;
  float array[7] = {1.0, 1e10, 3, 1e-10, -3, -1e-10, -1e10};  // --> 0, 1
  // float array[7] = {1.0, -3, 8e6, -3, 1e7, 6, -1.8e7}; // --> 2, 1
  //float array[7] = {1.0, 8e6, -3e-4, 1e7, -8e6, 3e-4, -1e7}; // --> 0, 1

  cout << "Sum with trySortedAccumulate as group (unsorted): " 
       << trySortedAccumulate(array, array+7, groupAdd, greaterAbs) << endl;
  cout << "Sum with trySortedAccumulate as Abelian group (sorted): " 
       << trySortedAccumulate(array, array+7, abelAdd, greaterAbs) << endl;
  cout << "The Result should be 1\n";

  return 0;
}
