#ifndef glas_default_functors_include
#define glas_default_functors_include

namespace glas { namespace def {

  template <class T>
  class magmaAdd {
  public:
    T operator() (const T& x, const T& y) {
      return x + y; }
  };

  template <class T>
  class semiGroupAdd: public magmaAdd<T> {};

  template <class T>
  class commSemiGroupAdd: public semiGroupAdd<T> {};

  template <class T, class SG= semiGroupAdd<T> >
  class monoidAdd: public SG {
  public:
    T identity() {
      return T(0); }
  };

  template <class T>
  class commMonoidAdd: public monoidAdd<T> {};

  template <class T>
  class groupAdd: public monoidAdd<T> {
  public:
    T inverse(const T& x) {
      return identity() - x; }
  };
  
  template <class T>
  class abeleanGroupAdd: public groupAdd<T> {};

  template <class T>
  class magmaMult {
  public:
    T operator() (const T& x, const T& y) {
      return x * y; }
  };

  template <class T>
  class semiGroupMult: public magmaMult<T> {};

  template <class T>
  class commSemiGroupMult: public semiGroupMult<T> {};

  template <class T>
  class monoidMult: public semiGroupMult<T> {
  public:
    T identity() {
      return T(1); }
  };

  template <class T>
  class commMonoidMult: public monoidMult<T> {};

  template <class T>
  class groupMult: public monoidMult<T> {
  public:
    T inverse(const T& x) {
      return identity() / x; }
  };
  

} // namespace def
} // namespace glas

#endif // glas_default_functors_include
