




// i) comparison tmp >= va2 is wrong in cyclic multiplicative groups
// ii) comparison tmp == va2 can result in endless loops
template <class Group, class Op>
int poorMensAbsDivision(const Group& v1, const Group& v2, 
		     Op op) {
  int counter= 0;
  Group va1(v1 < op.identity() ? op.inverse(v1) : v1), 
        va2(v2 < op.identity() ? op.inverse(v2) : v2);
  for (Group tmp(va1); tmp >= va2; counter++)
    tmp= op(tmp, op.inverse(va2));
  return counter;
}

// same remarks for poorMensDivision

// Does not always finish in cyclic multiplicative groups
template <class Group, class Op>
int poorMensDivision(const Group& v1, const Group& v2, 
		     Op op) {
  // copies to avoid redundant operations
  Group id(op.identity()), iv2(op.inverse(v2));

  if (v1 <= op.identity()) return 0;
  int counter= 1;
  for (Group tmp(v1); tmp >= id; counter++)
    tmp= op(tmp, iv2);
  return counter;
}


// --------------------
// checks associativity of Op, does not compile otherwise
template <class T, class Op>
inline typename enable_if<glas::is_commutative<Op>::value, T>::type
// inline T
multiplyAndSquare(T base, int exp, Op op) {
  cout << "Use multiplyAndSquare\n";
  T value(op.identity()), square(base);
  for (; exp > 0; exp>>= 1) {
    if (exp & 1) value= op(value, square);
    square= op(square, square); }
  return value;
}

template <class T, class Op>
inline T slowExponation(T base, int exp, Op op) {
  cout << "Use slowExponation\n";
  T value(op.identity());
  for (; exp > 0; exp--) 
    value= op(value, base);
  return value;
}
  
template <class T, class Op>
inline T exponation(T base, int exp, Op op) {
  return glas::is_commutative<Op>::value ? multiplyAndSquare(base, exp, op)
                                         : slowExponation(base, exp, op);
}
