// age_example2f.cpp
#include <iostream.h>
#include <cmath>

#include "algebraic_functions.hpp"

// User defined data types and operators
class age {
  double myAge;
 public:
  age(double m): myAge(m) {
    if (m < 0.0) throw "Negative Age"; }
  double sayAge() const {
    return myAge; }
  friend age& operator+=(age&, const age&);
};

inline bool operator==(const age& x, const age& y) {
  return x.sayAge() == y.sayAge(); }

inline ostream& operator<< (ostream& stream, const age& a) {
  return stream << a.sayAge(); }

struct pythagoras_t {
  age operator() (const age& x, const age& y) {
    return age(sqrt(x.sayAge()*x.sayAge() + y.sayAge()*y.sayAge())); }
} pythagoras;

struct pMonoid_t: public pythagoras_t {
  age identity() {
    return age(0); }
} pMonoid;

int main(int, char* []) {
  age a0(0.0), a2(2.0), a3(3.0), a4(4.0), a5(5.0);
  
  cout << "equalResults(a0,a5,  a3,a4, pythagoras) " 
       << equalResults(a0,a5,  a3,a4, pythagoras)  << endl;
  cout << "equalResults(a2,a4,  a3,a3, pMonoid) " 
       << equalResults(a2,a4,  a3,a3, pMonoid)  << endl;
  cout << "identityPair(a2,a4, pMonoid) " 
       << identityPair(a2,a4, pMonoid)  << endl;
  cout << "identityPair(a0,a0, pMonoid) " 
       << identityPair(a0,a0, pMonoid)  << endl; 
 
  return 0;
}
