#include <iostream.h>
#include <cmath>

#include "glas.hpp"
#include "algebraic_functions.hpp"

// User defined data types and operators

class age {
  double myAge;
 public:
  age(double m): myAge(m) {
    if (m < 0.0) throw "Negative Age"; }
  double sayAge() const {
    return myAge; }
};

inline age operator+(const age& x, const age& y) {
  return age(x.sayAge() + y.sayAge()); }

inline bool operator==(const age& x, const age& y) {
  return x.sayAge() == y.sayAge(); }

inline ostream& operator<< (ostream& stream, const age& a) {
  return stream << a.sayAge(); }

int main(int, char* []) {
  age a0(0.0), a2(2.0), a3(3.0), a4(4.0), a5(5.0);
  glas::def::magmaAddOp<age>    ageMagmaAdd;
  glas::def::monoidAddOp<age>   ageMonoidAdd;
  
  cout << "equalResults(a2,a5,  a3,a4, ageMagmaAdd) " 
       << equalResults(a2,a5,  a3,a4, ageMagmaAdd)  << endl;
  cout << "equalResults(a2,a4,  a3,a4, ageMagmaAdd) " 
       << equalResults(a2,a4,  a3,a4, ageMagmaAdd)  << endl;
  cout << "identityPair(a2,a4, ageMonoidAdd) " 
       << identityPair(a2,a4, ageMonoidAdd)  << endl;
  cout << "identityPair(a0,a0, ageMonoidAdd) " 
       << identityPair(a0,a0, ageMonoidAdd)  << endl;
  return 0;
}

