#include <fstream>          // std::ofstream
#include <boost/indent.hpp> // boost::indentor

// basic demonstration of the boost::indentor class
// NOTE: This can be plugged into tracing tools - I have used it
//   to track function calls with code similar to:
/*
#  if defined(TRACE_MODE)
#     define TRACE_FN                   \
         tracer::block __block( trace );\
         trace.indent()
#  else
#     define TRACE_FN /##/
#  endif

   // ...

   int MyFunction( const char * str )
   {
      TRACE_FN << "MyFunction( const char * = '" << str << "'" << '\n';

      if( str == 0 )                   return( -1 );
      std::cout << str;
      return( 0 );
   }
*/

int __cdecl main()
{
   typedef boost::indentor< std::ofstream >      indent_stream;
   indent_stream                       is;
   is.open( "results.txt" );
   
   is.indent() << "indentation tester" << '\n';
   is.beginIndent(); // manual indentation
   is.indent() << "Hello World!" << '\n';
   {
      // use a helper class to auto unindent when the __block object
      // goes out of scope
      
      indent_stream::block             __block( is );
      is.indent() << "Hello Indented World!" << '\n';
      is.indent() << "Hello Indented World!" << '\n';
      is.indent() << "Hello Indented World!" << '\n';
   }
   is.indent() << "Hello World!" << '\n';
   is.endIndent(); // manual unindent
   is.indent() << "[end of file]";

   return( 0 );
}
