#ifndef __BOOST__INDENT
#define __BOOST__INDENT
   /*
      change log:
      
      31/03/2003 - initial post to boost.org mailing list
      31/03/2003 - added security check for indentor::endIndent()
      31/03/2003 - added the ability for indentor::indent() to output a newline character
      31/03/2003 - set the foundation for parametizing the fill type
      31/03/2003 - fixed the syntax errors in the commented out review code
      03/04/3003 - indent() is now implemented using width() and fill() functions from OutputFileType
      03/04/3003 - completed char/wchar_t support by inheriting from OutputFileType
   */
   
#  include <iostream>

   namespace boost
   {
      template< class OutputFileType >
      class indentor: public OutputFileType
      {
         public:
            typedef typename OutputFileType::char_type     fill_type;
         private: // indentation
            struct
            {
               long                    level;
               fill_type               fill;
               char                    length;
            }                          m_indent;
         public:
                   indentor &                    indent( bool = false );
            inline indentor &                    beginIndent() throw();
            inline indentor &                    endIndent()   throw();
            inline void                          set_indent( char = 3, fill_type = static_cast< fill_type >( ' ' )) throw();
         public:
            class block
            {
               private:
                  indentor *           i;
               public:
                  inline     block( indentor & in ) throw(): i( &in )
                  {
                     i -> beginIndent();
                  }
                  inline    ~block() throw()
                  {
                     i -> endIndent();
                  }
            };
         private:
            inline indentor &     operator=( const indentor & ) throw(); // not implemented
            inline           indentor( const indentor & ) throw();       // not implemented
         public:
            inline           indentor() throw();
      };

      template< class OutputFileType >
      indentor< OutputFileType > & indentor< OutputFileType >::indent( bool nl )
      {
         if( nl )                      *this << '\n';
         if( m_indent.level == 0 )     return( *this );

         fill_type                     f = fill();
         std::streamsize               w = width();

         fill(  m_indent.fill );
         width( m_indent.level * m_indent.length );

         ( *this ) << static_cast< fill_type >( '\0' );

         fill(  f );
         width( w );

         return( *this );
      }
      template< class OutputFileType >
      indentor< OutputFileType > & indentor< OutputFileType >::beginIndent() throw()
      {
         ++m_indent.level;
         return( *this );
      }
      template< class OutputFileType >
      indentor< OutputFileType > & indentor< OutputFileType >::endIndent() throw()
      {
         if( m_indent.level > 0 )      --m_indent.level;
         return( *this );
      }

      template< class OutputFileType >
      void indentor< OutputFileType >::set_indent( char l, fill_type f ) throw()
      {
         m_indent.length = l;
         m_indent.fill   = f;
      }

      /*
      // [review]: MS bug (VC7 - has VC7.1 fixed this?)
      // >> cannot handle a nested class inside a template

      template< class OutputFileType >
      indentor< OutputFileType >::block::block( indentor< OutputFileType > & in ) throw(): i( &in )
      {
         i.beginIndent();
      }
      template< class OutputFileType >
      indentor< OutputFileType >::block::~block() throw()
      {
         i.beginIndent();
      }
      //*/

      template< class OutputFileType >
      indentor< OutputFileType >::indentor() throw()
      {
         m_indent.level  = 0;
         m_indent.fill   = static_cast< fill_type >( ' ' );
         m_indent.length = 3;
      }
   }
#endif
