//-----------------------------------------------------------------------------
// boost mpl/value_tag.hpp header file
// See http://www.boost.org for updates, documentation, and revision history.
//-----------------------------------------------------------------------------
//
// Copyright (c) 2002
// Terje Sletteb
//
// Permission to use, copy, modify, distribute and sell this software
// and its documentation for any purpose is hereby granted without fee,
// provided that the above copyright notice appears in all copies and
// that both the copyright notice and this permission notice appear in
// supporting documentation. No representations are made about the
// suitability of this software for any purpose. It is provided "as is"
// without express or implied warranty.

#ifndef BOOST_MPL_VALUE_TAG_HPP_INCLUDED
#define BOOST_MPL_VALUE_TAG_HPP_INCLUDED

namespace boost {
namespace mpl {

struct integral_value_tag;
struct ct_constant_tag;

// Paul Mensonides' routine for detecting a type member

template<class T>
class has_ct_tag
{
private:
  typedef char small_t;
  typedef char (& large_t)[256];

  template<class U>
  static small_t check(typename U::ct_tag *);

  template<class U>
  static large_t check(...);

public:
  static const bool value =
    sizeof(check<T>(0)) == sizeof(small_t);
};

} // namespace mpl
} // namespace boost

#endif // BOOST_MPL_VALUE_TAG_HPP_INCLUDED

