//-----------------------------------------------------------------------------
// boost mpl/arithmetic/pow.hpp header file
// See http://www.boost.org for updates, documentation, and revision history.
//-----------------------------------------------------------------------------
//
// Copyright (c) 2002
// Terje Sletteb
//
// Permission to use, copy, modify, distribute and sell this software
// and its documentation for any purpose is hereby granted without fee,
// provided that the above copyright notice appears in all copies and
// that both the copyright notice and this permission notice appear in
// supporting documentation. No representations are made about the
// suitability of this software for any purpose. It is provided "as is"
// without express or implied warranty.

#ifndef BOOST_MPL_ARITHMETIC_POW_HPP_INCLUDED
#define BOOST_MPL_ARITHMETIC_POW_HPP_INCLUDED

#include "value.hpp"
#include "multiplies.hpp"
#include "boost/mpl/apply.hpp"
#include "boost/mpl/if.hpp"
#include "boost/mpl/prior.hpp"
#include "boost/mpl/comparison/equal_to.hpp"
#include "boost/mpl/aux_/void_spec.hpp"
#include "boost/config.hpp"

namespace boost {
namespace mpl {

namespace aux {

template<typename B,typename E>
struct pow_impl_base
{
  typedef typename B::type Base;
  typedef typename E::type Exp;

  typedef typename if_<
    equal_to<Exp,value<Exp,0> >,
    value<Base,1>,
    multiplies<
      Base,
      pow_impl_base<Base,prior<Exp> >
    >
  >::type type;
};

template<typename ValueType>
struct pow_impl
{
  template<typename Base,typename Exp>
  struct apply : pow_impl_base<Base,Exp> {};
};

template<>
struct pow_impl<integral_value_tag>
{
  template<typename Base,typename Exp>
  struct apply : pow_impl_base<Base,Exp>
  {
    typedef typename pow_impl_base<Base,Exp>::type::type base_class;

    BOOST_STATIC_CONSTANT(base_class::value_type, value = base_class::value);

    static typename base_class::type result(Base base,Exp exp) { return base_class::type(); }
  };
};

} // namespace aux

template<
  typename BOOST_MPL_AUX_VOID_SPEC_PARAM(Base),
  typename BOOST_MPL_AUX_VOID_SPEC_PARAM(Exp)
>
struct pow : apply2<aux::pow_impl<typename Base::value_tag>,Base,Exp> {};

template<
  typename T, T Base, T Exp
>
struct pow_c : pow<integral_c<T,Base>,integral_c<T,Exp> > {};

#if defined(BOOST_MSVC) && BOOST_MSVC <= 1300
// ETI workaround
//template<>
//struct pow_c<long,0,0>
//{
//    typedef long value_type;
//
//    typedef pow_c type;
//
//    BOOST_STATIC_CONSTANT(long, value = 1);
//};
#endif

BOOST_MPL_AUX_VOID_SPEC(2,pow)

} // namespace mpl
} // namespace boost

#endif // BOOST_MPL_ARITHMETIC_POW_HPP_INCLUDED
