//-----------------------------------------------------------------------------
// boost mpl/arithmetic/multiplies.hpp header file
// See http://www.boost.org for updates, documentation, and revision history.
//-----------------------------------------------------------------------------
//
// Copyright (c) 2000-02
// Aleksey Gurtovoy
//
// Permission to use, copy, modify, distribute and sell this software
// and its documentation for any purpose is hereby granted without fee,
// provided that the above copyright notice appears in all copies and
// that both the copyright notice and this permission notice appear in
// supporting documentation. No representations are made about the
// suitability of this software for any purpose. It is provided "as is"
// without express or implied warranty.
//
// Modified by Terje Sletteb 2002

#ifndef BOOST_MPL_ARITHMETIC_MULTIPLIES_HPP_INCLUDED
#define BOOST_MPL_ARITHMETIC_MULTIPLIES_HPP_INCLUDED

#include "integral_c.hpp"
#include "boost/mpl/apply.hpp"
#include "boost/mpl/aux_/void_spec.hpp"
#include "boost/config.hpp"

namespace boost {
namespace mpl {

namespace aux {

template<typename ValueType>
struct multiplies_impl;

template<>
struct multiplies_impl<integral_value_tag>
{
    template<typename T1,typename T2,typename T3,typename T4,typename T5>
    struct apply : integral_c<
        typename T1::value_type
        , T1::value * T2::value * T3::value * T4::value * T5::value
    > {};
};

} // namespace aux

template<
      typename BOOST_MPL_AUX_VOID_SPEC_PARAM(T1)
    , typename BOOST_MPL_AUX_VOID_SPEC_PARAM(T2)
    , typename T3 = integral_c<int,1>
    , typename T4 = integral_c<int,1>
    , typename T5 = integral_c<int,1>
    >
struct multiplies : apply5<
    aux::multiplies_impl<typename T1::type::value_tag>
    , typename T1::type
    , typename T2::type
    , typename T3::type
    , typename T4::type
    , typename T5::type
> {};

template<typename T, T N1, T N2, T N3 = 1, T N4 = 1, T N5 = 1>
struct multiplies_c :
    multiplies<
        integral_c<T,N1>
      , integral_c<T,N2>
      , integral_c<T,N3>
      , integral_c<T,N4>
      , integral_c<T,N5>
  > {};

BOOST_MPL_AUX_VOID_SPEC_EXT(2,5,multiplies)

} // namespace mpl
} // namespace boost

#endif // BOOST_MPL_ARITHMETIC_MULTIPLIES_HPP_INCLUDED
