///////////////////////////////////////////////////////////////////////////////
// Test program for pow(), demonstrating compile-time, run-time, and combined
// evaluation, also called partial evaluation.
//
// Copyright Terje Sletteb 2002.
//
// Permission to use, copy, modify, distribute and sell this software
// and its documentation for any purpose is hereby granted without fee,
// provided that the above copyright notice appears in all copies and
// that both the copyright notice and this permission notice appear in
// supporting documentation. No representations are made about the
// suitability of this software for any purpose. It is provided "as is"
// without express or implied warranty.
///////////////////////////////////////////////////////////////////////////////

#include <iostream>
#include "int_c.hpp"
#include "runtime_pow.hpp"

using namespace boost::mpl;

const int base=10;
const int exponent=3;

int main()
{
int_c<base> base_const;
int_c<exponent> exponent_const;

int result_pow=runtime::pow(base_const,exponent_const);    // pow(constant,constant) - result=1000
int result_exp_constant=runtime::pow(base,exponent_const); // pow(runtime,constant)  - result=base*base*base=1000
int result_runtime_pow=runtime::pow(base,exponent);        // pow(runtime,runtime)   - result=std::pow(base,exponent)=1000

std::cout << result_pow << '\n';
std::cout << result_exp_constant << '\n';
std::cout << result_runtime_pow << '\n';
}
