#define BOOST_TEST_MODULE inprogress_test_suite

#include <boost/pretty_print.hpp>
#include <boost/test/unit_test.hpp>

#include <boost/exception/diagnostic_information.hpp>

#include <boost/archive/xml_iarchive.hpp>
#include <boost/archive/xml_oarchive.hpp>

#include <test-dll/objects.hpp>
#include <test-dll/serialize.hpp>

BOOST_AUTO_TEST_CASE(test)
{
  // Serialization through derived instance.
  {
    std::stringstream ss;
    constexpr double  params[cpe::derived_t::size] = {1000, 1000, 200, 200};
    cpe::derived_t    instance{1, params};
    {
      boost::archive::xml_oarchive oa{ss};
      BOOST_CHECK_NO_THROW(oa << BOOST_SERIALIZATION_NVP(instance));
    }

    cpe::derived_t restored;
    {
      boost::archive::xml_iarchive ia{ss};
      BOOST_CHECK_NO_THROW(ia >> BOOST_SERIALIZATION_NVP(restored));
    }

    BOOST_TEST(instance.id == restored.id);
    BOOST_TEST(instance.params == restored.params);
  }


  // Serialization through base pointer.
  {
    std::stringstream ss;
    constexpr double  params[cpe::derived_t::size] = {1000, 1000, 200, 200};
    auto              instance{std::make_unique<cpe::derived_t>(1, params)};
    {
      cpe::object_t* base{instance.get()};
      boost::archive::xml_oarchive oa{ss};
      BOOST_CHECK_NO_THROW(oa << boost::serialization::make_nvp("base", base));
    }

    std::unique_ptr<cpe::derived_t> restored;
    {
      cpe::object_t* base{};
      boost::archive::xml_iarchive ia{ss};
      BOOST_CHECK_NO_THROW(ia >> boost::serialization::make_nvp("base", base));
    }

    BOOST_REQUIRE(restored);
    BOOST_TEST(instance->id == restored->id);
    BOOST_TEST(instance->params == restored->params);
  }
}