
#ifndef _SERIAL_PORT_
#define _SERIAL_PORT_

#include <boost/asio.hpp>
#include <boost/asio/serial_port.hpp>
#include <boost/thread.hpp>
#include <boost/signals2/signal.hpp>
#include <boost/scoped_ptr.hpp>
#include <boost/enable_shared_from_this.hpp>

#include <string>
#include <deque>
#include <boost/bind.hpp>
#include <boost/date_time/posix_time/posix_time_types.hpp>

using namespace std;


typedef boost::signals2::connection       _signal_conn;     //Define a signal connection
typedef boost::signals2::signal<void ()>  _signal_void;     //Define a signal type for OnData event

typedef _signal_void::slot_type           _slot_type_void;  //Define a slot type for connecting to the signal void


class SerialPort : public boost::enable_shared_from_this<SerialPort>
{
public:
  SerialPort(boost::asio::io_service &_io);
  void Write(const std::string msg);
  bool Open(std::string name);
  void Close();
  bool Active();

private:

  static const int max_read_length = 512; // maximum amount of data to read in one operation
 
  void read_start(void);
  void read_complete(const boost::system::error_code& error, size_t bytes_transferred);
  void do_write(std::string msg);
  void write_start(void);
  void write_complete(const boost::system::error_code& error);
  void do_close(const boost::system::error_code& error);

  _signal_conn OnData(const _slot_type_void& s);

private:
  bool        active_; // remains true while this object is still operating
  char        read_msg_[max_read_length]; // data read from the socket
  deque<char> write_msgs_; // buffered write data
  
  boost::asio::io_service&      io_service_; // the main IO service that runs this connection
  boost::asio::serial_port      serialPort; // the serial port this instance is connected to

  _signal_void    signal_OnData;      //Raised when data is readed
};

#endif _SERIAL_PORT_