#include "Serial_OK.hpp"

using namespace std;


SerialPort::SerialPort(boost::asio::io_service& io_service)
                      : active_(true),
                        io_service_(io_service),
                        serialPort(io_service)
{
  
  //if (!serialPort.is_open())
  //{
  //  cerr << "Failed to open serial port\n";
  //  return;
  //}
  //boost::asio::serial_port_base::baud_rate baud_option(9600);
  //serialPort.set_option(baud_option); // set the baud rate after the port has been opened
  //read_start();
}

bool SerialPort::Open(std::string name)
{
  serialPort.open(name);
  if (!serialPort.is_open())
  {
    cerr << "Failed to open serial port\n";
    return false;
  }
  boost::asio::serial_port_base::baud_rate baud_option(9600);
  serialPort.set_option(baud_option); // set the baud rate after the port has been opened
  read_start();
  return true;
}

void SerialPort::Write(const std::string msg) // pass the write data to the do_write function via the io service in the other thread
{
  //io_service_.post(boost::bind(&SerialPort::do_write, this, msg));
  size_t ret = boost::asio::write(serialPort, boost::asio::buffer(msg.c_str(), msg.size()));
  std::cout << ret << std::endl;
}

void SerialPort::Close() // call the do_close function via the io service in the other thread
{
  io_service_.post(boost::bind(&SerialPort::do_close, this, boost::system::error_code()));
}

bool SerialPort::Active() // return true if the socket is still active
{
  return active_;
}


void SerialPort::read_start(void)
{ // Start an asynchronous read and call read_complete when it completes or fails
  serialPort.async_read_some(boost::asio::buffer(read_msg_, max_read_length),
                              boost::bind(&SerialPort::read_complete,
                              this,
                              boost::asio::placeholders::error,
                              boost::asio::placeholders::bytes_transferred));
}

void SerialPort::read_complete(const boost::system::error_code& error, size_t bytes_transferred)
{ // the asynchronous read operation has now completed or failed and returned an error
  if (!error)
  { // read completed, so process the data
    cout.write(read_msg_, bytes_transferred); // echo to standard output
    cout << "-----" << endl;
    read_start(); // start waiting for another asynchronous read again
  }
  else
    do_close(error);
}

void SerialPort::do_write(std::string msg)
{ // callback to handle write call from outside this class
  //bool write_in_progress = !write_msgs_.empty(); // is there anything currently being written?
  //write_msgs_.push_back(msg); // store in write buffer
  //write_msgs_.assign(msg.begin(), msg.end()); // store in write buffer
  //if (!write_in_progress) // if nothing is currently being written, then start
  //{
          //write_start();

    size_t ret = boost::asio::write(serialPort, boost::asio::buffer(msg.c_str(), msg.size()));
    std::cout << ret << std::endl;
  //}
}

void SerialPort::write_start(void)
{ // Start an asynchronous write and call write_complete when it completes or fails
  boost::asio::async_write(serialPort,
                            boost::asio::buffer(&write_msgs_.front(), 1),
                            boost::bind(&SerialPort::write_complete,
                            this,
                            boost::asio::placeholders::error));
}

void SerialPort::write_complete(const boost::system::error_code& error)
{ // the asynchronous read operation has now completed or failed and returned an error
  if (!error)
  { // write completed, so send next write data
    write_msgs_.pop_front(); // remove the completed data
    if (!write_msgs_.empty()) // if there is anthing left to be written
            write_start(); // then start sending the next item in the buffer
  }
  else
    do_close(error);
}

void SerialPort::do_close(const boost::system::error_code& error)
{ // something has gone wrong, so close the socket & make this object inactive
  if (error == boost::asio::error::operation_aborted) // if this call is the result of a timer cancel()
    return; // ignore it because the connection cancelled the timer
  if (error)
    cerr << "Error: " << error.message() << endl; // show the error message
  else
    cout << "Error: Connection did not succeed.\n";
  cout << "Press Enter to exit\n";
  serialPort.close();
  active_ = false;
}
