
#include "MyATLib.hpp"
#include "ATModem.hpp"

// Main io_service
static boost::asio::io_service          io_service;
static boost::scoped_ptr<boost::thread> io_service_thread;
static bool thread_started;


extern "C" __declspec(dllexport) ATModemHndl CALL CreateATModemObj(void)
{  
  if (!thread_started) {
    try {
      // run the IO service as a separate thread
      io_service_thread.reset(new boost::thread( boost::bind(&boost::asio::io_service::run, &io_service) ));
      thread_started = !thread_started;
    } catch (boost::thread_resource_error e) {
      // Failed to create the new thread
      return 0;
    }
  }
  // create the new object
  return new ATModem(io_service);

  //return new TETRAMoto();
};