#ifndef _ATMODEM_H
#define _ATMODEM_H

#include "MyATLib.hpp"

#ifdef _USE_SERIAL_OK
  #include "Serial_OK.hpp"
#else
  #include "Serial.hpp"
#endif

#include "ATDispatcher.hpp"

class ATModem : public DLLImpl<IATModem>
{
public:
  void Connect(void);
  bool active();

  ATModem(boost::asio::io_service &io_service);
  ~ATModem();

private:
  SerialPort _serial_port;
  boost::scoped_ptr<ATDispatcher> _dispatcher;
};

#endif _ATMODEM_H