/////////////////////////////////////////////////////////////////////////////
// Name:        ATDispatcher.cpp
// Purpose:     Implementation of the AT dispatcher class
// Author:      Daniele Barzotti
// Id:          $Id: ATDispatcher.cpp,v 1.0.0.0 2009/02/-- jb Exp $
// Copyright:   (c) 2009 Eurocom Telecomunicazioni
// Licence:
/////////////////////////////////////////////////////////////////////////////


#include "ATDispatcher.hpp"
#include <string>


//--------------------------------------------------------------------------------------

void ATDispatcher::OnDataReceived()
{  
  // Parse the answer....

  // _waiting_answer indicates that we're waiting an answer to SendCommand()
  if (_waiting_answer)
  {
    _data_ready = true;    
    // Notify and unlock the mutex
    _cond.notify_one();
    // raise the "event"
    if (_forward_answer) signal_OnData();
  } 
  else
  {
    // This is an unsilicited message: raise the "event"
    signal_OnData();
  }

};


//--------------------------------------------------------------------------------------

ATDispatcher::ATDispatcher(SerialPort& device) : _device(device), _read_thread_ptr(0)
{
  // Connecting the slot for receiving event
//  _device.OnData(boost::bind(&ATDispatcher::OnDataReceived, this));
  
  StartString = "\r\n";
  EndString = "\r\n\r\nOK\r\n";
  
  ParseBuffer = false;
  ResetVars();
};

//--------------------------------------------------------------------------------------

ATDispatcher::~ATDispatcher(void)
{
};

//--------------------------------------------------------------------------------------

void ATDispatcher::ResetVars(void)
{
  _waiting_answer = false;
  _data_ready = false;
  _error = false;
  _waitOK = false;
};

//--------------------------------------------------------------------------------------

void ATDispatcher::GetRawData(std::string& buffer)
{
  // Locking the vector
  //boost::lock_guard<boost::mutex> lock(_mut);
  boost::mutex::scoped_lock lock(_mut);
  buffer.assign(_buffer);
  _buffer.clear();
};

//--------------------------------------------------------------------------------------

void ATDispatcher::GetParsedData(std::vector<std::string>& buffer)
{
  // Locking the vector
  OutputDebugStringA("GetParsedData called \n");
  boost::mutex::scoped_lock lock(_mut);
  buffer.assign(_parsed_buffer.begin(), _parsed_buffer.end());
  _parsed_buffer.clear();
};


//--------------------------------------------------------------------------------------


ATDispatcher::EDispatcherRetVal ATDispatcher::SendCommand(const char* cmd, 
                                                          bool waitOK, 
                                                          bool parse_answer,
                                                          bool append_CR,
                                                          bool forward_answer,
                                                          INT  cmd_timeout)
{
  std::string t_cmd(cmd);
  return this->SendCommand(t_cmd, waitOK, parse_answer, append_CR, forward_answer, cmd_timeout);
};

//--------------------------------------------------------------------------------------

ATDispatcher::EDispatcherRetVal ATDispatcher::SendCommand(std::string& cmd, 
                                                          bool waitOK, 
                                                          bool parse_answer,
                                                          bool append_CR,
                                                          bool forward_answer,
                                                          INT  cmd_timeout)
{
    //Create the lock for the conditional variable
    boost::mutex _cond_mutex;
    boost::unique_lock<boost::mutex> _cond_lock(_cond_mutex);

    boost::xtime xt;
    xtime_get(&xt, boost::TIME_UTC);
    xt.sec += cmd_timeout;

    ResetVars();
    _waitOK = waitOK;
    _forward_answer = forward_answer;
    ParseBuffer = parse_answer;
    _waiting_answer = true;
    
    if (true){
      boost::mutex::scoped_lock _lock(_mut);
      _buffer.clear();
    }

    if (append_CR) cmd += "\r\n";

    // Write data on RS232
    _device.Write(cmd);

    // Waiting for modem answer
    // The timed_wait will returns if the timer expires 
    // or if the conditional is notified (when data is arrived)
    bool ready = _cond.timed_wait(_cond_lock, xt, boost::lambda::var(_data_ready)); 
    
    ResetVars();

    if (_error)
      return  RET_ERROR;
    else
      return (ready ? RET_OK : RET_TIMEOUT);
};

//--------------------------------------------------------------------------------------

_signal_conn ATDispatcher::OnData(const _slot_type_void& s)
{
  return signal_OnData.connect(s);
};

//--------------------------------------------------------------------------------------
