/* minicom.cpp
        A simple demonstration minicom client with Boost asio
       
        Parameters:
                baud rate
                serial port (eg /dev/ttyS0 or COM1)
               
        To end the application, send Ctrl-C on standard input
*/

#include "stdafx.h"

#include "MyATLib.hpp"

#include <iostream>
#include <boost/lexical_cast.hpp>
#include <boost/scoped_ptr.hpp>

using namespace std;


int main(int argc, char* argv[])
{
  try
  {
    if (argc != 3)
    {
      cerr << "Usage: minicom <baud> <device>\n";
      return 1;
    }
    // define an instance of the main class of this program
    boost::scoped_ptr<IATModem> _dev( CreateATModemObj() );

    while (_dev->active()) // check the internal state of the connection to make sure it's still running
    {
      char ch;
      cin.get(ch); // blocking wait for standard input
      if (ch == 3) // ctrl-C to end program
        break;

      _dev->Connect();

    }
  }
  catch (exception& e)
  {
    cerr << "Exception: " << e.what() << "\n";
  }
#ifdef POSIX // restore default buffering of standard input
  tcsetattr(0, TCSANOW, &stored_settings);
#endif
  return 0;
}
