// non_finite_num_facets_test.cpp

// Tests for the class templates num_put_extended and num_get_extended

// Copyright (c) 2006 Johan Rde
// Distributed under the Boost Software License, Version 1.0. 
// (See http://www.boost.org/LICENSE_1_0.txt)

#include <cassert>
#include <iostream>
#include <sstream>

#include "non_finite_num_facets.hpp"

using namespace std;

//--------------------------------------------------------------------------------------------------

void test_finite();
void test_inf();
void test_nan();

int main()
{
	test_finite();		// test writing and reading finite numbers
	test_inf();			// test writing and reading infinity
	test_nan();			// test writing and reading nan
}

//--------------------------------------------------------------------------------------------------

template<class CharType, class FloatType> void test_finite_impl();

void test_finite()
{
	test_finite_impl<char, float>();
	test_finite_impl<char, double>();
	test_finite_impl<char, long double>();
	test_finite_impl<wchar_t, float>();
	test_finite_impl<wchar_t, double>();
	test_finite_impl<wchar_t, long double>();
}

template<class CharType, class FloatType> void test_finite_impl()
{
	locale old_locale;
	locale tmp_locale(old_locale, new num_get_extended<CharType>);
	locale new_locale(tmp_locale, new num_put_extended<CharType>);

	basic_stringstream<CharType> ss;
	ss.imbue(new_locale);

	FloatType a1 = (FloatType)2.3;
	FloatType a2 = (FloatType)-3.5;
	ss << a1;
	ss << ' ';
	ss << a2;

	FloatType b1, b2;
	ss >> b1;
	ss >> b2;

	assert(b1 == a1);
	assert(b2 == a2);
	assert(!ss.fail());
}

//--------------------------------------------------------------------------------------------------

template<class CharType, class FloatType> void test_inf_impl();

void test_inf()
{
	test_inf_impl<char, float>();
	test_inf_impl<char, double>();
	test_inf_impl<char, long double>();
	test_inf_impl<wchar_t, float>();
	test_inf_impl<wchar_t, double>();
	test_inf_impl<wchar_t, long double>();
}

template<class CharType, class FloatType> void test_inf_impl()
{
	assert(std::numeric_limits<FloatType>::has_infinity);

	locale old_locale;
	locale tmp_locale(old_locale, new num_get_extended<CharType>);
	locale new_locale(tmp_locale, new num_put_extended<CharType>);

	basic_stringstream<CharType> ss;
	ss.imbue(new_locale);

	FloatType a1 = numeric_limits<FloatType>::infinity();
	FloatType a2 = -a1;
	ss << a1;
	ss << ' ';
	ss << a2;
	ss << " ing";

	FloatType b1, b2;
	ss >> b1;
	ss >> b2;

	assert(b1 == a1);
	assert(b2 == a2);
	assert(!ss.fail());

	FloatType b3;
	ss >> b3;
	assert(ss.fail());
}

//--------------------------------------------------------------------------------------------------

template<class CharType, class FloatType> void test_nan_impl();

void test_nan()
{
	test_nan_impl<char, float>();
	test_nan_impl<char, double>();
	test_nan_impl<char, long double>();
	test_nan_impl<wchar_t, float>();
	test_nan_impl<wchar_t, double>();
	test_nan_impl<wchar_t, long double>();
}

template<class CharType, class FloatType> void test_nan_impl()
{
	assert(std::numeric_limits<FloatType>::has_quiet_NaN);
	assert(std::numeric_limits<FloatType>::has_signaling_NaN);

	locale old_locale;
	locale tmp_locale(old_locale, new num_get_extended<CharType>);
	locale new_locale(tmp_locale, new num_put_extended<CharType>);

	basic_stringstream<CharType> ss;
	ss.imbue(new_locale);

	FloatType a1 = numeric_limits<FloatType>::quiet_NaN();
	FloatType a2 = numeric_limits<FloatType>::signaling_NaN();
	ss << a1;
	ss << ' ';
	ss << a2;
	ss << " nam";

	FloatType b1, b2;
	ss >> b1;
	ss >> b2;

	assert(b1 == a1 || !(b1 == b1));
	assert(b2 == a2 || !(b2 == b2));
	assert(!ss.fail());

	FloatType b3;
	ss >> b3;
	assert(ss.fail());
}
